/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.ssblur.scriptor.item.books.ObfuscatedSpellbook;
import com.ssblur.scriptor.item.books.Spellbook;
import com.ssblur.scriptor.recipe.ScriptorRecipes;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016J\f\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001eH\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006 "}, d2={"Lcom/ssblur/scriptor/recipe/SpellbookDyeingRecipe;", "Lnet/minecraft/world/item/crafting/CustomRecipe;", "addition", "Lnet/minecraft/world/item/crafting/Ingredient;", "result", "Lnet/minecraft/world/item/ItemStack;", "<init>", "(Lnet/minecraft/world/item/crafting/Ingredient;Lnet/minecraft/world/item/ItemStack;)V", "getAddition", "()Lnet/minecraft/world/item/crafting/Ingredient;", "setAddition", "(Lnet/minecraft/world/item/crafting/Ingredient;)V", "getResult", "()Lnet/minecraft/world/item/ItemStack;", "setResult", "(Lnet/minecraft/world/item/ItemStack;)V", "matches", "", "container", "Lnet/minecraft/world/item/crafting/CraftingInput;", "level", "Lnet/minecraft/world/level/Level;", "assemble", "access", "Lnet/minecraft/core/HolderLookup$Provider;", "canCraftInDimensions", "i", "", "j", "getSerializer", "Lnet/minecraft/world/item/crafting/RecipeSerializer;", "Serializer", "scriptor"})
public final class SpellbookDyeingRecipe
extends CustomRecipe {
    @NotNull
    private Ingredient addition;
    @NotNull
    private ItemStack result;

    public SpellbookDyeingRecipe(@NotNull Ingredient addition, @NotNull ItemStack result) {
        Intrinsics.checkNotNullParameter((Object)addition, (String)"addition");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        super(CraftingBookCategory.MISC);
        this.addition = addition;
        this.result = result;
    }

    @NotNull
    public final Ingredient getAddition() {
        return this.addition;
    }

    public final void setAddition(@NotNull Ingredient ingredient) {
        Intrinsics.checkNotNullParameter((Object)ingredient, (String)"<set-?>");
        this.addition = ingredient;
    }

    @NotNull
    public final ItemStack getResult() {
        return this.result;
    }

    public final void setResult(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"<set-?>");
        this.result = itemStack;
    }

    public boolean matches(@NotNull CraftingInput container, @NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        return container.items().stream().anyMatch(arg_0 -> SpellbookDyeingRecipe.matches$lambda$1(SpellbookDyeingRecipe::matches$lambda$0, arg_0)) && container.items().stream().anyMatch(arg_0 -> SpellbookDyeingRecipe.matches$lambda$3(arg_0 -> SpellbookDyeingRecipe.matches$lambda$2(this, arg_0), arg_0));
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingInput container, @NotNull HolderLookup.Provider access) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)access, (String)"access");
        ItemStack craftingBase = null;
        for (ItemStack item : container.items()) {
            if (!(item.getItem() instanceof Spellbook) || item.getItem() instanceof ObfuscatedSpellbook) continue;
            if (craftingBase == null) {
                craftingBase = item;
                continue;
            }
            ItemStack itemStack = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            return itemStack;
        }
        if (craftingBase == null) {
            ItemStack itemStack = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            return itemStack;
        }
        ItemStack craftingResult = this.result.copy();
        craftingResult.applyComponents(craftingBase.getComponents());
        Intrinsics.checkNotNull((Object)craftingResult);
        return craftingResult;
    }

    public boolean canCraftInDimensions(int i, int j) {
        return i * j >= 2;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ScriptorRecipes.INSTANCE.getSPELLBOOK_DYEING().get();
    }

    private static final boolean matches$lambda$0(ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        return itemStack.getItem() instanceof Spellbook && !(itemStack.getItem() instanceof ObfuscatedSpellbook);
    }

    private static final boolean matches$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean matches$lambda$2(SpellbookDyeingRecipe this$0, ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return this$0.addition.test(itemStack);
    }

    private static final boolean matches$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006H\u0016J\u0014\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/ssblur/scriptor/recipe/SpellbookDyeingRecipe$Serializer;", "Lnet/minecraft/world/item/crafting/RecipeSerializer;", "Lcom/ssblur/scriptor/recipe/SpellbookDyeingRecipe;", "<init>", "()V", "codec", "Lcom/mojang/serialization/MapCodec;", "streamCodec", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "Companion", "scriptor"})
    public static final class Serializer
    implements RecipeSerializer<SpellbookDyeingRecipe> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final MapCodec<SpellbookDyeingRecipe> CODEC;
        @NotNull
        private static final StreamCodec<RegistryFriendlyByteBuf, SpellbookDyeingRecipe> STREAM_CODEC;

        @NotNull
        public MapCodec<SpellbookDyeingRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, SpellbookDyeingRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static final Ingredient CODEC$lambda$3$lambda$0(SpellbookDyeingRecipe recipe) {
            Intrinsics.checkNotNullParameter((Object)((Object)recipe), (String)"recipe");
            return recipe.getAddition();
        }

        private static final ItemStack CODEC$lambda$3$lambda$1(SpellbookDyeingRecipe recipe) {
            Intrinsics.checkNotNullParameter((Object)((Object)recipe), (String)"recipe");
            return recipe.getResult();
        }

        private static final SpellbookDyeingRecipe CODEC$lambda$3$lambda$2(Ingredient addition, ItemStack result) {
            Intrinsics.checkNotNullParameter((Object)addition, (String)"addition");
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            return new SpellbookDyeingRecipe(addition, result);
        }

        private static final App CODEC$lambda$3(RecordCodecBuilder.Instance instance) {
            Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
            return instance.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("addition").forGetter(Serializer::CODEC$lambda$3$lambda$0), (App)ItemStack.CODEC.fieldOf("result").forGetter(Serializer::CODEC$lambda$3$lambda$1)).apply((Applicative)instance, Serializer::CODEC$lambda$3$lambda$2);
        }

        private static final Ingredient STREAM_CODEC$lambda$4(SpellbookDyeingRecipe recipe) {
            Intrinsics.checkNotNullParameter((Object)((Object)recipe), (String)"recipe");
            return recipe.getAddition();
        }

        private static final ItemStack STREAM_CODEC$lambda$5(SpellbookDyeingRecipe recipe) {
            Intrinsics.checkNotNullParameter((Object)((Object)recipe), (String)"recipe");
            return recipe.getResult();
        }

        private static final SpellbookDyeingRecipe STREAM_CODEC$lambda$6(Ingredient addition, ItemStack result) {
            Intrinsics.checkNotNullParameter((Object)addition, (String)"addition");
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            return new SpellbookDyeingRecipe(addition, result);
        }

        static {
            MapCodec mapCodec = RecordCodecBuilder.mapCodec(Serializer::CODEC$lambda$3);
            Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"mapCodec(...)");
            CODEC = mapCodec;
            StreamCodec streamCodec = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, Serializer::STREAM_CODEC$lambda$4, (StreamCodec)ItemStack.STREAM_CODEC, Serializer::STREAM_CODEC$lambda$5, Serializer::STREAM_CODEC$lambda$6);
            Intrinsics.checkNotNullExpressionValue((Object)streamCodec, (String)"composite(...)");
            STREAM_CODEC = streamCodec;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/ssblur/scriptor/recipe/SpellbookDyeingRecipe$Serializer$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/MapCodec;", "Lcom/ssblur/scriptor/recipe/SpellbookDyeingRecipe;", "getCODEC", "()Lcom/mojang/serialization/MapCodec;", "STREAM_CODEC", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "getSTREAM_CODEC", "()Lnet/minecraft/network/codec/StreamCodec;", "scriptor"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final MapCodec<SpellbookDyeingRecipe> getCODEC() {
                return CODEC;
            }

            @NotNull
            public final StreamCodec<RegistryFriendlyByteBuf, SpellbookDyeingRecipe> getSTREAM_CODEC() {
                return STREAM_CODEC;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

