/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.resources;

import com.ssblur.scriptor.ScriptorMod;
import com.ssblur.scriptor.advancement.ScriptorAdvancements;
import com.ssblur.scriptor.data.components.ScriptorDataComponents;
import com.ssblur.scriptor.data.saved_data.DictionarySavedData;
import com.ssblur.scriptor.data.saved_data.PlayerSpellsSavedData;
import com.ssblur.scriptor.item.ScriptorItems;
import com.ssblur.scriptor.resources.Tomes;
import com.ssblur.unfocused.ModInitializer;
import com.ssblur.unfocused.advancement.GenericTrigger;
import com.ssblur.unfocused.data.DataLoaderRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010'\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00100\u000f2\u0006\u0010\u000e\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001b"}, d2={"Lcom/ssblur/scriptor/resources/Scraps;", "", "<init>", "()V", "scraps", "", "Lnet/minecraft/resources/ResourceLocation;", "Lcom/ssblur/scriptor/resources/Scraps$ScrapResource;", "getScraps", "()Ljava/util/Map;", "random", "Lkotlin/random/Random;", "getRandom", "()Lkotlin/random/Random;", "tier", "", "", "", "(I)[Ljava/util/Map$Entry;", "getRandomScrap", "", "t", "player", "Lnet/minecraft/world/entity/player/Player;", "getRandomScrapItem", "Lnet/minecraft/world/item/ItemStack;", "ScrapResource", "scriptor"})
@SourceDebugExtension(value={"SMAP\nScraps.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Scraps.kt\ncom/ssblur/scriptor/resources/Scraps\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,80:1\n774#2:81\n865#2,2:82\n37#3,2:84\n37#3,2:86\n*S KotlinDebug\n*F\n+ 1 Scraps.kt\ncom/ssblur/scriptor/resources/Scraps\n*L\n26#1:81\n26#1:82,2\n26#1:84,2\n38#1:86,2\n*E\n"})
public final class Scraps {
    @NotNull
    public static final Scraps INSTANCE = new Scraps();
    @NotNull
    private static final Map<ResourceLocation, ScrapResource> scraps = DataLoaderRegistry.INSTANCE.registerSimpleDataLoader((ModInitializer)ScriptorMod.INSTANCE, "scriptor/scraps", Reflection.getOrCreateKotlinClass(ScrapResource.class));
    @NotNull
    private static final Random random = RandomKt.Random((long)System.nanoTime());

    private Scraps() {
    }

    @NotNull
    public final Map<ResourceLocation, ScrapResource> getScraps() {
        return scraps;
    }

    @NotNull
    public final Random getRandom() {
        return random;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map.Entry<ResourceLocation, ScrapResource>[] tier(int tier) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = scraps.entrySet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            if (!(((ScrapResource)it.getValue()).getTier() == tier)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Map.Entry[0]);
    }

    @NotNull
    public final String getRandomScrap(int t, @NotNull Player player) {
        PlayerSpellsSavedData data;
        Level level;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Object[] options = this.tier(t);
        if (ScriptorMod.INSTANCE.getCOMMUNITY_MODE() && (level = player.level()) instanceof ServerLevel) {
            int bracket = (int)((ServerLevel)level).getSeed() % 5;
            bracket = Math.min((bracket + 10) % 5, options.length - 1);
            List filtered = new ArrayList();
            int n = options.length;
            for (int i = 0; i < n; ++i) {
                if (bracket != i % 5) continue;
                filtered.add(options[i]);
            }
            Collection $this$toTypedArray$iv = filtered;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            options = thisCollection$iv.toArray(new Map.Entry[0]);
        }
        if ((data = PlayerSpellsSavedData.Companion.computeIfAbsent(player)) != null) {
            HashMap<String, Boolean> known = data.getScrapTier(t);
            ((GenericTrigger)ScriptorAdvancements.INSTANCE.getTOME().get()).trigger((ServerPlayer)player);
            if (options.length <= known.size()) {
                return (String)CollectionsKt.random((Collection)options[random.nextInt(options.length)].getValue().getKeys(), (Random)((Random)Random.Default));
            }
            int maxAttempts = 10;
            Map.Entry resource = null;
            int index = 0;
            ResourceLocation key = null;
            do {
                resource = (Map.Entry)ArraysKt.random((Object[])options, (Random)((Random)Random.Default));
                index = RangesKt.random((IntRange)CollectionsKt.getIndices((Collection)((ScrapResource)resource.getValue()).getKeys()), (Random)((Random)Random.Default));
                key = ((ResourceLocation)resource.getKey()).withSuffix("." + StringsKt.replace$default((String)((ScrapResource)resource.getValue()).getKeys().get(index), (String)":", (String)".", (boolean)false, (int)4, null));
            } while (--maxAttempts > 0 && known.containsKey(key.toShortLanguageKey()));
            ((Map)known).put(key.toShortLanguageKey(), true);
            data.setDirty();
            return ((ScrapResource)resource.getValue()).getKeys().get(index);
        }
        return (String)CollectionsKt.random((Collection)options[Tomes.INSTANCE.getRandom().nextInt(options.length)].getValue().getKeys(), (Random)((Random)Random.Default));
    }

    @NotNull
    public final ItemStack getRandomScrapItem(int t, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        String scrap = this.getRandomScrap(t, player);
        ItemStack itemStack = new ItemStack((Holder)ScriptorItems.INSTANCE.getSCRAP());
        itemStack.set(ScriptorDataComponents.INSTANCE.getSPELL(), (Object)scrap);
        Level level = player.level();
        Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        String word = DictionarySavedData.Companion.computeIfAbsent((ServerLevel)level).getWord(scrap);
        if (word != null) {
            itemStack.set(DataComponents.ITEM_NAME, (Object)Component.literal((String)word));
        } else {
            itemStack.set(DataComponents.ITEM_NAME, (Object)Component.literal((String)("Invalid word: " + scrap)));
        }
        if (ScriptorMod.INSTANCE.getCOMMUNITY_MODE()) {
            itemStack.set(ScriptorDataComponents.INSTANCE.getCOMMUNITY_MODE(), (Object)true);
        }
        return itemStack;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u0013\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0004H\u00d6\u0001R \u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lcom/ssblur/scriptor/resources/Scraps$ScrapResource;", "", "keys", "", "", "tier", "", "<init>", "(Ljava/util/List;I)V", "getKeys", "()Ljava/util/List;", "setKeys", "(Ljava/util/List;)V", "getTier", "()I", "setTier", "(I)V", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "scriptor"})
    public static final class ScrapResource {
        @NotNull
        private List<String> keys;
        private int tier;

        public ScrapResource(@NotNull List<String> keys, int tier) {
            Intrinsics.checkNotNullParameter(keys, (String)"keys");
            this.keys = keys;
            this.tier = tier;
        }

        public /* synthetic */ ScrapResource(List list, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                n = 0;
            }
            this(list, n);
        }

        @NotNull
        public final List<String> getKeys() {
            return this.keys;
        }

        public final void setKeys(@NotNull List<String> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.keys = list;
        }

        public final int getTier() {
            return this.tier;
        }

        public final void setTier(int n) {
            this.tier = n;
        }

        @NotNull
        public final List<String> component1() {
            return this.keys;
        }

        public final int component2() {
            return this.tier;
        }

        @NotNull
        public final ScrapResource copy(@NotNull List<String> keys, int tier) {
            Intrinsics.checkNotNullParameter(keys, (String)"keys");
            return new ScrapResource(keys, tier);
        }

        public static /* synthetic */ ScrapResource copy$default(ScrapResource scrapResource, List list, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                list = scrapResource.keys;
            }
            if ((n2 & 2) != 0) {
                n = scrapResource.tier;
            }
            return scrapResource.copy(list, n);
        }

        @NotNull
        public String toString() {
            return "ScrapResource(keys=" + this.keys + ", tier=" + this.tier + ")";
        }

        public int hashCode() {
            int result = ((Object)this.keys).hashCode();
            result = result * 31 + Integer.hashCode(this.tier);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ScrapResource)) {
                return false;
            }
            ScrapResource scrapResource = (ScrapResource)other;
            if (!Intrinsics.areEqual(this.keys, scrapResource.keys)) {
                return false;
            }
            return this.tier == scrapResource.tier;
        }
    }
}

