/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.word;

import com.ssblur.scriptor.ScriptorMod;
import com.ssblur.scriptor.advancement.ScriptorAdvancements;
import com.ssblur.scriptor.api.word.Descriptor;
import com.ssblur.scriptor.api.word.Subject;
import com.ssblur.scriptor.api.word.Word;
import com.ssblur.scriptor.effect.ScriptorEffects;
import com.ssblur.scriptor.helpers.targetable.EntityTargetable;
import com.ssblur.scriptor.helpers.targetable.Targetable;
import com.ssblur.scriptor.network.client.ParticleNetwork;
import com.ssblur.scriptor.word.PartialSpell;
import com.ssblur.scriptor.word.descriptor.AfterCastDescriptor;
import com.ssblur.scriptor.word.descriptor.CastDescriptor;
import com.ssblur.scriptor.word.descriptor.focus.FocusDescriptor;
import com.ssblur.scriptor.word.descriptor.target.TargetDescriptor;
import com.ssblur.unfocused.advancement.GenericTrigger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ&\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0015J\u001a\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00130\u00172\u0006\u0010\u0018\u001a\u00020\u0011J\u000e\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J'\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00112\u0012\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0005\"\u00020\u0011\u00a2\u0006\u0002\u0010\u001bJ\u0006\u0010\u001c\u001a\u00020\u001dJ\u0015\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001f0\u0005H\u0002\u00a2\u0006\u0002\u0010 J\u0011\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u0005\u00a2\u0006\u0002\u0010#R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001b\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\f\u00a8\u0006$"}, d2={"Lcom/ssblur/scriptor/word/Spell;", "", "subject", "Lcom/ssblur/scriptor/api/word/Subject;", "spells", "", "Lcom/ssblur/scriptor/word/PartialSpell;", "<init>", "(Lcom/ssblur/scriptor/api/word/Subject;[Lcom/ssblur/scriptor/word/PartialSpell;)V", "getSubject", "()Lcom/ssblur/scriptor/api/word/Subject;", "getSpells", "()[Lcom/ssblur/scriptor/word/PartialSpell;", "[Lcom/ssblur/scriptor/word/PartialSpell;", "castOnTargets", "", "originalCaster", "Lcom/ssblur/scriptor/helpers/targetable/Targetable;", "originalTargets", "", "castHooks", "", "createFuture", "Ljava/util/concurrent/CompletableFuture;", "caster", "cast", "targetables", "(Lcom/ssblur/scriptor/helpers/targetable/Targetable;[Lcom/ssblur/scriptor/helpers/targetable/Targetable;)V", "cost", "", "words", "Lcom/ssblur/scriptor/api/word/Word;", "()[Lcom/ssblur/scriptor/api/word/Word;", "deduplicatedDescriptorsForSubjects", "Lcom/ssblur/scriptor/api/word/Descriptor;", "()[Lcom/ssblur/scriptor/api/word/Descriptor;", "scriptor"})
@SourceDebugExtension(value={"SMAP\nSpell.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Spell.kt\ncom/ssblur/scriptor/word/Spell\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,189:1\n10009#2:190\n10431#2,5:191\n37#3,2:196\n*S KotlinDebug\n*F\n+ 1 Spell.kt\ncom/ssblur/scriptor/word/Spell\n*L\n187#1:190\n187#1:191,5\n187#1:196,2\n*E\n"})
public final class Spell {
    @NotNull
    private final Subject subject;
    @NotNull
    private final PartialSpell[] spells;

    public Spell(@NotNull Subject subject, PartialSpell ... spells) {
        Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
        Intrinsics.checkNotNullParameter((Object)spells, (String)"spells");
        this.subject = subject;
        this.spells = spells;
    }

    @NotNull
    public final Subject getSubject() {
        return this.subject;
    }

    @NotNull
    public final PartialSpell[] getSpells() {
        return this.spells;
    }

    /*
     * WARNING - void declaration
     */
    public final void castOnTargets(@NotNull Targetable originalCaster, @NotNull List<? extends Targetable> originalTargets, boolean castHooks) {
        boolean bl;
        Entity entity;
        Intrinsics.checkNotNullParameter((Object)originalCaster, (String)"originalCaster");
        Intrinsics.checkNotNullParameter(originalTargets, (String)"originalTargets");
        Targetable caster = originalCaster;
        Entity entity2 = entity = caster instanceof EntityTargetable ? ((EntityTargetable)caster).getTargetEntity() : null;
        if (castHooks) {
            for (Descriptor descriptor : this.spells[0].deduplicatedDescriptors()) {
                if (descriptor instanceof CastDescriptor && ((CastDescriptor)((Object)descriptor)).cannotCast(caster)) {
                    if (entity instanceof Player) {
                        ((Player)entity).sendSystemMessage((Component)Component.translatable((String)"extra.scriptor.condition_not_met"));
                        ((GenericTrigger)ScriptorAdvancements.INSTANCE.getFIZZLE().get()).trigger((ServerPlayer)entity);
                    }
                    if (!caster.getLevel().isClientSide) {
                        ParticleNetwork.INSTANCE.fizzle(caster.getLevel(), caster.getTargetBlockPos());
                    }
                    return;
                }
                if (!(descriptor instanceof FocusDescriptor)) continue;
                caster = ((FocusDescriptor)((Object)descriptor)).modifyFocus(caster);
            }
        }
        boolean bl2 = bl = !(this.spells.length == 0);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        for (PartialSpell partialSpell : this.spells) {
            void var13_21;
            Targetable caster2 = originalCaster;
            List<? extends Targetable> targets = originalTargets;
            Descriptor[] descriptorArray = partialSpell.deduplicatedDescriptors();
            boolean bl3 = false;
            int n = descriptorArray.length;
            while (var13_21 < n) {
                Descriptor descriptor = descriptorArray[var13_21];
                if (descriptor instanceof TargetDescriptor) {
                    targets = ((TargetDescriptor)((Object)descriptor)).modifyTargets(targets, caster2);
                }
                if (descriptor instanceof FocusDescriptor) {
                    caster2 = ((FocusDescriptor)((Object)descriptor)).modifyFocus(caster2);
                }
                ++var13_21;
            }
            for (Targetable targetable : targets) {
                partialSpell.getAction().apply(caster2, targetable, partialSpell.deduplicatedDescriptors());
            }
        }
        if (castHooks) {
            for (Descriptor descriptor : this.spells[0].deduplicatedDescriptors()) {
                if (!(descriptor instanceof AfterCastDescriptor)) continue;
                ((AfterCastDescriptor)((Object)descriptor)).afterCast(caster);
            }
        }
    }

    public static /* synthetic */ void castOnTargets$default(Spell spell, Targetable targetable, List list, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        spell.castOnTargets(targetable, list, bl);
    }

    @NotNull
    public final CompletableFuture<List<Targetable>> createFuture(@NotNull Targetable caster) {
        Intrinsics.checkNotNullParameter((Object)caster, (String)"caster");
        CompletableFuture<List<Targetable>> targetFuture = new CompletableFuture<List<Targetable>>();
        targetFuture.whenComplete((arg_0, arg_1) -> Spell.createFuture$lambda$1((arg_0, arg_1) -> Spell.createFuture$lambda$0(this, caster, arg_0, arg_1), arg_0, arg_1));
        return targetFuture;
    }

    public final void cast(@NotNull Targetable originalCaster) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)originalCaster, (String)"originalCaster");
        Entity entity = null;
        Ref.ObjectRef caster = new Ref.ObjectRef();
        caster.element = originalCaster;
        if (caster.element instanceof EntityTargetable && (entity = ((EntityTargetable)caster.element).getTargetEntity()) instanceof LivingEntity && ((LivingEntity)entity).hasEffect((Holder)ScriptorEffects.INSTANCE.getMUTE().ref())) {
            if (entity instanceof Player) {
                ((Player)entity).sendSystemMessage((Component)Component.translatable((String)"extra.scriptor.mute"));
            }
            return;
        }
        boolean bl2 = bl = !(this.spells.length == 0);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Descriptor[] descriptorArray = this.spells[0].deduplicatedDescriptors();
        int n = descriptorArray.length;
        for (int i = 0; i < n; ++i) {
            Descriptor descriptor = descriptorArray[i];
            if (descriptor instanceof CastDescriptor && ((CastDescriptor)((Object)descriptor)).cannotCast((Targetable)caster.element)) {
                if (entity instanceof Player) {
                    ((Player)entity).sendSystemMessage((Component)Component.translatable((String)"extra.scriptor.condition_not_met"));
                    ((GenericTrigger)ScriptorAdvancements.INSTANCE.getFIZZLE().get()).trigger((ServerPlayer)entity);
                }
                if (!((Targetable)caster.element).getLevel().isClientSide) {
                    ParticleNetwork.INSTANCE.fizzle(((Targetable)caster.element).getLevel(), ((Targetable)caster.element).getTargetBlockPos());
                }
                return;
            }
            if (!(descriptor instanceof FocusDescriptor)) continue;
            caster.element = ((FocusDescriptor)((Object)descriptor)).modifyFocus((Targetable)caster.element);
        }
        CompletableFuture<List<Targetable>> targetFuture = this.subject.getTargets((Targetable)caster.element, this);
        for (Descriptor descriptor : this.spells[0].deduplicatedDescriptors()) {
            if (!(descriptor instanceof AfterCastDescriptor)) continue;
            ((AfterCastDescriptor)((Object)descriptor)).afterCast((Targetable)caster.element);
        }
        if (targetFuture.isDone()) {
            try {
                Targetable targetable = ((Targetable)caster.element).getFinalTargetable();
                Intrinsics.checkNotNull((Object)targetable);
                List<Targetable> list = targetFuture.get();
                Intrinsics.checkNotNullExpressionValue(list, (String)"get(...)");
                Spell.castOnTargets$default(this, targetable, list, false, 4, null);
            }
            catch (InterruptedException e) {
                ScriptorMod.INSTANCE.getLOGGER().error((Object)e);
            }
            catch (ExecutionException e) {
                ScriptorMod.INSTANCE.getLOGGER().error((Object)e);
            }
        } else {
            targetFuture.whenComplete((arg_0, arg_1) -> Spell.cast$lambda$3((arg_0, arg_1) -> Spell.cast$lambda$2(this, caster, arg_0, arg_1), arg_0, arg_1));
        }
    }

    public final void cast(@NotNull Targetable caster, Targetable ... targetables) {
        Intrinsics.checkNotNullParameter((Object)caster, (String)"caster");
        Intrinsics.checkNotNullParameter((Object)targetables, (String)"targetables");
        Spell.castOnTargets$default(this, caster, ArraysKt.toList((Object[])targetables), false, 4, null);
    }

    public final double cost() {
        double sum = 0.0;
        double scalar = 1.0;
        double discount = 0.0;
        double subCount = 0.0;
        double sub = 0.0;
        Word[] wordArray = this.words();
        int n = wordArray.length;
        block5: for (int i = 0; i < n; ++i) {
            Word d;
            Word word = d = wordArray[i];
            Intrinsics.checkNotNull((Object)word);
            Word.Cost cost = word.cost();
            switch (WhenMappings.$EnumSwitchMapping$0[cost.type().ordinal()]) {
                case 1: {
                    if (sum < 0.0) {
                        double d2 = subCount;
                        subCount = d2 + 1.0;
                        sub += cost.cost();
                        continue block5;
                    }
                    sum += cost.cost();
                    continue block5;
                }
                case 2: {
                    scalar *= cost.cost();
                    continue block5;
                }
                case 3: {
                    discount += cost.cost();
                    continue block5;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        if (subCount > 0.0) {
            double squeeze = 0.5;
            double denominator = 1.0 - (squeeze - Math.pow(squeeze, subCount));
            sum -= sub / denominator;
        }
        return sum * scalar + discount;
    }

    private final Word[] words() {
        int length = 1;
        int index = 1;
        PartialSpell[] partialSpellArray = this.spells;
        int n = partialSpellArray.length;
        for (int i = 0; i < n; ++i) {
            PartialSpell spell = partialSpellArray[i];
            length += spell.deduplicatedDescriptors().length + 1;
        }
        Word[] words = new Word[length];
        words[0] = this.subject;
        for (PartialSpell spell : this.spells) {
            words[index] = spell.getAction();
            Descriptor[] descriptors = spell.deduplicatedDescriptors();
            System.arraycopy(descriptors, 0, words, ++index, descriptors.length);
            index += descriptors.length;
        }
        return words;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Descriptor[] deduplicatedDescriptorsForSubjects() {
        void $this$flatMapTo$iv$iv;
        PartialSpell[] $this$flatMap$iv = this.spells;
        boolean $i$f$flatMap = false;
        PartialSpell[] partialSpellArray = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        int n = ((void)$this$flatMapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$flatMapTo$iv$iv[i];
            boolean bl = false;
            Iterable list$iv$iv = ArraysKt.toList((Object[])it.getDescriptors());
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Collection $this$toTypedArray$iv = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Descriptor[0]);
    }

    private static final Unit createFuture$lambda$0(Spell this$0, Targetable $caster, List targets, Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$caster, (String)"$caster");
        if (throwable == null) {
            Intrinsics.checkNotNull((Object)targets);
            Spell.castOnTargets$default(this$0, $caster, targets, false, 4, null);
        }
        return Unit.INSTANCE;
    }

    private static final void createFuture$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final Unit cast$lambda$2(Spell this$0, Ref.ObjectRef $caster, List targets, Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$caster, (String)"$caster");
        Throwable throwable2 = throwable;
        if (throwable2 == null) {
            Targetable targetable = ((Targetable)$caster.element).getFinalTargetable();
            Intrinsics.checkNotNull((Object)targetable);
            Intrinsics.checkNotNull((Object)targets);
            Spell.castOnTargets$default(this$0, targetable, targets, false, 4, null);
            throwable2 = Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    private static final void cast$lambda$3(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Word.COSTTYPE.values().length];
            try {
                nArray[Word.COSTTYPE.ADDITIVE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Word.COSTTYPE.MULTIPLICATIVE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Word.COSTTYPE.ADDITIVE_POST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

