/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.word.action.potions;

import com.ssblur.scriptor.api.word.Descriptor;
import com.ssblur.scriptor.api.word.Word;
import com.ssblur.scriptor.helpers.targetable.Targetable;
import com.ssblur.scriptor.network.client.ParticleNetwork;
import com.ssblur.scriptor.word.action.potions.PotionAction;
import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JA\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lcom/ssblur/scriptor/word/action/potions/WitherAction;", "Lcom/ssblur/scriptor/word/action/potions/PotionAction;", "<init>", "()V", "applyToPosition", "", "caster", "Lcom/ssblur/scriptor/helpers/targetable/Targetable;", "targetable", "descriptors", "", "Lcom/ssblur/scriptor/api/word/Descriptor;", "strength", "", "duration", "(Lcom/ssblur/scriptor/helpers/targetable/Targetable;Lcom/ssblur/scriptor/helpers/targetable/Targetable;[Lcom/ssblur/scriptor/api/word/Descriptor;DD)V", "Companion", "scriptor"})
public final class WitherAction
extends PotionAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Random RANDOM = new Random();

    public WitherAction() {
        Holder holder = MobEffects.WITHER;
        Intrinsics.checkNotNullExpressionValue((Object)holder, (String)"WITHER");
        super((Holder<MobEffect>)holder, 30.0, 0.3333333333333333, new Word.Cost(12.0, Word.COSTTYPE.ADDITIVE));
    }

    @Override
    public void applyToPosition(@Nullable Targetable caster, @Nullable Targetable targetable, @Nullable Descriptor[] descriptors, double strength, double duration) {
        BlockState state;
        Integer age;
        boolean playAnimation = false;
        Targetable targetable2 = targetable;
        Intrinsics.checkNotNull((Object)targetable2);
        Level level = targetable2.getLevel();
        BlockPos pos = targetable.getOffsetBlockPos();
        if (level.getBlockState(pos).hasProperty((Property)CropBlock.AGE) && (age = (Integer)(state = level.getBlockState(pos)).getValue((Property)CropBlock.AGE)) > 0) {
            playAnimation = true;
            int i = 0;
            while ((double)i < strength + 1.0) {
                age = (int)Math.max((double)(age - (RANDOM.nextInt(2) + 1)), 0.0);
                ++i;
            }
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)CropBlock.AGE, (Comparable)age));
        }
        if (playAnimation) {
            ParticleNetwork.INSTANCE.wither(level, pos);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/ssblur/scriptor/word/action/potions/WitherAction$Companion;", "", "<init>", "()V", "RANDOM", "Ljava/util/Random;", "getRANDOM", "()Ljava/util/Random;", "scriptor"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Random getRANDOM() {
            return RANDOM;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

