/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.word.descriptor.target;

import com.ssblur.scriptor.api.word.Descriptor;
import com.ssblur.scriptor.api.word.Word;
import com.ssblur.scriptor.helpers.targetable.Targetable;
import com.ssblur.scriptor.word.descriptor.target.TargetDescriptor;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J$\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\t\u001a\u00020\u0007H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/ssblur/scriptor/word/descriptor/target/NetherDescriptor;", "Lcom/ssblur/scriptor/api/word/Descriptor;", "Lcom/ssblur/scriptor/word/descriptor/target/TargetDescriptor;", "<init>", "()V", "modifyTargets", "", "Lcom/ssblur/scriptor/helpers/targetable/Targetable;", "originalTargetables", "owner", "replacesSubjectCost", "", "cost", "Lcom/ssblur/scriptor/api/word/Word$Cost;", "scriptor"})
public final class NetherDescriptor
extends Descriptor
implements TargetDescriptor {
    @Override
    @NotNull
    public List<Targetable> modifyTargets(@NotNull List<? extends Targetable> originalTargetables, @NotNull Targetable owner) {
        Intrinsics.checkNotNullParameter(originalTargetables, (String)"originalTargetables");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        List list = new ArrayList();
        for (Targetable targetable : originalTargetables) {
            Level level = targetable.getLevel();
            ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
            if (serverLevel == null) continue;
            ServerLevel level2 = serverLevel;
            ServerLevel nether = level2.getServer().getLevel(Level.NETHER);
            if (nether == null || !level2.getServer().isLevelEnabled((Level)nether)) {
                return originalTargetables;
            }
            if (level2.dimension() != Level.OVERWORLD && level2.dimension() != Level.NETHER) {
                list.add(targetable);
                continue;
            }
            ServerLevel targetLevel = level2.getServer().getLevel(level2.dimension() == Level.NETHER ? Level.OVERWORLD : Level.NETHER);
            double scale = level2.dimension() == Level.NETHER ? 8.0 : 0.125;
            Vec3 pos = targetable.getTargetPos();
            double x = pos.x * scale;
            double z = pos.z * scale;
            ServerLevel serverLevel2 = targetLevel;
            Intrinsics.checkNotNull((Object)serverLevel2);
            list.add(new Targetable((Level)serverLevel2, new Vec3(x, pos.y, z)));
        }
        return list;
    }

    @Override
    public boolean replacesSubjectCost() {
        return false;
    }

    @Override
    @NotNull
    public Word.Cost cost() {
        return Word.Cost.Companion.add(20.0);
    }
}

