/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.word.subject;

import com.ssblur.scriptor.api.word.Subject;
import com.ssblur.scriptor.api.word.Word;
import com.ssblur.scriptor.color.CustomColors;
import com.ssblur.scriptor.helpers.targetable.EntityTargetable;
import com.ssblur.scriptor.helpers.targetable.LecternTargetable;
import com.ssblur.scriptor.helpers.targetable.Targetable;
import com.ssblur.scriptor.network.client.ParticleNetwork;
import com.ssblur.scriptor.network.server.TraceNetwork;
import com.ssblur.scriptor.word.Spell;
import com.ssblur.scriptor.word.descriptor.target.CollideWithWaterDescriptor;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00052\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/ssblur/scriptor/word/subject/HitscanSubject;", "Lcom/ssblur/scriptor/api/word/Subject;", "<init>", "()V", "getTargets", "Ljava/util/concurrent/CompletableFuture;", "", "Lcom/ssblur/scriptor/helpers/targetable/Targetable;", "caster", "spell", "Lcom/ssblur/scriptor/word/Spell;", "cost", "Lcom/ssblur/scriptor/api/word/Word$Cost;", "scriptor"})
public final class HitscanSubject
extends Subject {
    @Override
    @NotNull
    public CompletableFuture<List<Targetable>> getTargets(@NotNull Targetable caster, @NotNull Spell spell) {
        Intrinsics.checkNotNullParameter((Object)caster, (String)"caster");
        Intrinsics.checkNotNullParameter((Object)spell, (String)"spell");
        CompletableFuture<List<Targetable>> result = new CompletableFuture<List<Targetable>>();
        if (caster instanceof EntityTargetable && ((EntityTargetable)caster).getTargetEntity() instanceof Player) {
            Entity entity = ((EntityTargetable)caster).getTargetEntity();
            Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.player.Player");
            Player player = (Player)entity;
            TraceNetwork.INSTANCE.requestExtendedTraceData(player, ArraysKt.contains((Object[])spell.deduplicatedDescriptorsForSubjects(), (Object)CollideWithWaterDescriptor.INSTANCE), arg_0 -> HitscanSubject.getTargets$lambda$0(spell, player, result, arg_0));
        } else if (caster instanceof LecternTargetable) {
            BlockPos pos = caster.getTargetBlockPos().relative(caster.getFacing());
            Vec3i normal = caster.getFacing().getNormal();
            int x = normal.getX() * 19;
            int z = normal.getZ() * 19;
            List entities = caster.getLevel().getEntitiesOfClass(LivingEntity.class, AABB.ofSize((Vec3)new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()), (double)(1 + x), (double)1.0, (double)(1 + z)));
            if (entities.isEmpty()) {
                x = caster.getFacing().getStepX();
                z = caster.getFacing().getStepZ();
                for (int i = 0; i < 19; ++i) {
                    if (caster.getLevel().getBlockState(pos.offset(x * i, 0, z * i)).isAir()) continue;
                    Level level = caster.getLevel();
                    BlockPos blockPos = pos.offset(x * i, 0, z * i);
                    Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"offset(...)");
                    result.complete(CollectionsKt.listOf((Object)new Targetable(level, blockPos)));
                    return result;
                }
            } else {
                result.complete(entities.stream().map(arg_0 -> HitscanSubject.getTargets$lambda$2(HitscanSubject::getTargets$lambda$1, arg_0)).toList());
            }
        } else {
            result.complete(CollectionsKt.listOf((Object)caster.simpleCopy()));
        }
        return result;
    }

    @Override
    @NotNull
    public Word.Cost cost() {
        return new Word.Cost(8.0, Word.COSTTYPE.ADDITIVE);
    }

    private static final void getTargets$lambda$0(Spell $spell, Player $player, CompletableFuture $result, Targetable target) {
        Intrinsics.checkNotNullParameter((Object)$spell, (String)"$spell");
        Intrinsics.checkNotNullParameter((Object)$player, (String)"$player");
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        int color = CustomColors.INSTANCE.getColor($spell.deduplicatedDescriptorsForSubjects());
        Level level = target.getLevel();
        Vec3 vec3 = $player.getEyePosition();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getEyePosition(...)");
        ParticleNetwork.INSTANCE.magicTrail(level, color, vec3, target.getTargetPos());
        $result.complete(CollectionsKt.listOf((Object)target));
    }

    private static final EntityTargetable getTargets$lambda$1(LivingEntity it) {
        Intrinsics.checkNotNull((Object)it);
        return new EntityTargetable((Entity)it);
    }

    private static final EntityTargetable getTargets$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (EntityTargetable)$tmp0.invoke(p0);
    }
}

