/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.word.subject;

import com.ssblur.scriptor.api.word.Subject;
import com.ssblur.scriptor.api.word.Word;
import com.ssblur.scriptor.helpers.targetable.EntityTargetable;
import com.ssblur.scriptor.helpers.targetable.ItemTargetable;
import com.ssblur.scriptor.helpers.targetable.Targetable;
import com.ssblur.scriptor.word.Spell;
import com.ssblur.scriptor.word.subject.InventorySubject;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J$\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0016"}, d2={"Lcom/ssblur/scriptor/word/subject/ImbueSubject;", "Lcom/ssblur/scriptor/api/word/Subject;", "Lcom/ssblur/scriptor/word/subject/InventorySubject;", "<init>", "()V", "getTargets", "Ljava/util/concurrent/CompletableFuture;", "", "Lcom/ssblur/scriptor/helpers/targetable/Targetable;", "caster", "spell", "Lcom/ssblur/scriptor/word/Spell;", "cost", "Lcom/ssblur/scriptor/api/word/Word$Cost;", "castOnItem", "", "player", "Lnet/minecraft/world/entity/player/Player;", "slot", "Lnet/minecraft/world/item/ItemStack;", "canBeCastOnInventory", "", "scriptor"})
public final class ImbueSubject
extends Subject
implements InventorySubject {
    @Override
    @NotNull
    public CompletableFuture<List<Targetable>> getTargets(@NotNull Targetable caster, @NotNull Spell spell) {
        Intrinsics.checkNotNullParameter((Object)caster, (String)"caster");
        Intrinsics.checkNotNullParameter((Object)spell, (String)"spell");
        if (caster instanceof EntityTargetable && ((EntityTargetable)caster).getTargetEntity() instanceof Player) {
            Entity entity = ((EntityTargetable)caster).getTargetEntity();
            Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.player.Player");
            ((Player)entity).sendSystemMessage((Component)Component.translatable((String)"extra.scriptor.enchant_wrong"));
        }
        CompletableFuture<List<Targetable>> future = new CompletableFuture<List<Targetable>>();
        future.complete(CollectionsKt.emptyList());
        return future;
    }

    @Override
    @NotNull
    public Word.Cost cost() {
        return new Word.Cost(10.0, Word.COSTTYPE.MULTIPLICATIVE);
    }

    @Override
    public void castOnItem(@NotNull Spell spell, @NotNull Player player, @NotNull ItemStack slot) {
        Intrinsics.checkNotNullParameter((Object)spell, (String)"spell");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
        Targetable[] targetableArray = new Targetable[]{new ItemTargetable(slot, player)};
        spell.cast(new EntityTargetable((Entity)player), targetableArray);
    }

    @Override
    public boolean canBeCastOnInventory() {
        return true;
    }
}

