/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.word.subject;

import com.ssblur.scriptor.api.word.Descriptor;
import com.ssblur.scriptor.api.word.Subject;
import com.ssblur.scriptor.api.word.Word;
import com.ssblur.scriptor.color.CustomColors;
import com.ssblur.scriptor.entity.ScriptorEntities;
import com.ssblur.scriptor.entity.ScriptorProjectile;
import com.ssblur.scriptor.helpers.targetable.EntityTargetable;
import com.ssblur.scriptor.helpers.targetable.LecternTargetable;
import com.ssblur.scriptor.helpers.targetable.Targetable;
import com.ssblur.scriptor.network.server.TraceNetwork;
import com.ssblur.scriptor.word.Spell;
import com.ssblur.scriptor.word.descriptor.SpeedDescriptor;
import com.ssblur.scriptor.word.descriptor.duration.DurationDescriptor;
import com.ssblur.scriptor.word.descriptor.target.CollideWithWaterDescriptor;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00052\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J2\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005J\b\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/ssblur/scriptor/word/subject/MeteorSubject;", "Lcom/ssblur/scriptor/api/word/Subject;", "<init>", "()V", "getTargets", "Ljava/util/concurrent/CompletableFuture;", "", "Lcom/ssblur/scriptor/helpers/targetable/Targetable;", "caster", "spell", "Lcom/ssblur/scriptor/word/Spell;", "spawnMeteorOver", "", "level", "Lnet/minecraft/world/level/Level;", "position", "Lnet/minecraft/world/phys/Vec3;", "action", "cost", "Lcom/ssblur/scriptor/api/word/Word$Cost;", "scriptor"})
public final class MeteorSubject
extends Subject {
    @Override
    @NotNull
    public CompletableFuture<List<Targetable>> getTargets(@NotNull Targetable caster, @NotNull Spell spell) {
        Intrinsics.checkNotNullParameter((Object)caster, (String)"caster");
        Intrinsics.checkNotNullParameter((Object)spell, (String)"spell");
        CompletableFuture<List<Targetable>> result = new CompletableFuture<List<Targetable>>();
        if (caster instanceof EntityTargetable && ((EntityTargetable)caster).getTargetEntity() instanceof Player) {
            Entity entity = ((EntityTargetable)caster).getTargetEntity();
            Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.player.Player");
            Player player = (Player)entity;
            TraceNetwork.INSTANCE.requestExtendedTraceData(player, ArraysKt.contains((Object[])spell.deduplicatedDescriptorsForSubjects(), (Object)CollideWithWaterDescriptor.INSTANCE), arg_0 -> MeteorSubject.getTargets$lambda$0(this, spell, result, arg_0));
        } else if (caster instanceof LecternTargetable) {
            BlockPos pos = caster.getTargetBlockPos().relative(caster.getFacing());
            Vec3i normal = caster.getFacing().getNormal();
            int x = normal.getX() * 19;
            int z = normal.getZ() * 19;
            List entities = caster.getLevel().getEntitiesOfClass(LivingEntity.class, AABB.ofSize((Vec3)new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()), (double)(1 + x), (double)1.0, (double)(1 + z)));
            if (entities.isEmpty()) {
                x = caster.getFacing().getStepX();
                z = caster.getFacing().getStepZ();
                for (int i = 0; i < 19; ++i) {
                    if (caster.getLevel().getBlockState(pos.offset(x * i, 0, z * i)).isAir()) continue;
                    Level level = caster.getLevel();
                    Vec3 vec3 = pos.offset(x * i, 0, z * i).getCenter();
                    Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getCenter(...)");
                    this.spawnMeteorOver(level, vec3, spell, result);
                    return result;
                }
            } else {
                Level level = caster.getLevel();
                Intrinsics.checkNotNull((Object)entities);
                Vec3 vec3 = ((LivingEntity)CollectionsKt.first((List)entities)).position();
                Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
                this.spawnMeteorOver(level, vec3, spell, result);
            }
        } else {
            result.complete(CollectionsKt.listOf((Object)caster.simpleCopy()));
        }
        return result;
    }

    public final void spawnMeteorOver(@NotNull Level level, @NotNull Vec3 position, @NotNull Spell spell, @NotNull CompletableFuture<List<Targetable>> action) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)spell, (String)"spell");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        CompletableFuture<List<Targetable>> future = new CompletableFuture<List<Targetable>>();
        int color = CustomColors.INSTANCE.getColor(spell.deduplicatedDescriptorsForSubjects());
        double duration = 12.0;
        double speed = 0.6;
        for (Descriptor d : spell.deduplicatedDescriptorsForSubjects()) {
            if (d instanceof DurationDescriptor) {
                duration += ((DurationDescriptor)((Object)d)).durationModifier();
            }
            if (!(d instanceof SpeedDescriptor)) continue;
            speed *= ((SpeedDescriptor)((Object)d)).speedModifier();
        }
        speed *= 0.8;
        Entity entity = ((EntityType)ScriptorEntities.INSTANCE.getPROJECTILE_TYPE().get()).create(level);
        if (entity == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        ScriptorProjectile projectile = (ScriptorProjectile)entity;
        projectile.setPos(position.add(0.0, 16.0, 0.0));
        projectile.setDeltaMovement(new Vec3(0.0, -1.0, 0.0).scale(speed));
        projectile.setDuration((int)Math.round((double)10 * duration));
        projectile.setColor(color);
        projectile.setCompletable(future);
        level.addFreshEntity((Entity)projectile);
        future.thenAccept(arg_0 -> MeteorSubject.spawnMeteorOver$lambda$2(arg_0 -> MeteorSubject.spawnMeteorOver$lambda$1(action, arg_0), arg_0));
    }

    @Override
    @NotNull
    public Word.Cost cost() {
        return new Word.Cost(8.0, Word.COSTTYPE.ADDITIVE);
    }

    private static final void getTargets$lambda$0(MeteorSubject this$0, Spell $spell, CompletableFuture $result, Targetable target) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$spell, (String)"$spell");
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this$0.spawnMeteorOver(target.getLevel(), target.getTargetPos(), $spell, $result);
    }

    private static final Unit spawnMeteorOver$lambda$1(CompletableFuture $action, List it) {
        Intrinsics.checkNotNullParameter((Object)$action, (String)"$action");
        $action.complete(it);
        return Unit.INSTANCE;
    }

    private static final void spawnMeteorOver$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

