/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.word.subject;

import com.ssblur.scriptor.api.word.Subject;
import com.ssblur.scriptor.api.word.Word;
import com.ssblur.scriptor.block.ScriptorBlocks;
import com.ssblur.scriptor.blockentity.RuneBlockEntity;
import com.ssblur.scriptor.color.CustomColors;
import com.ssblur.scriptor.helpers.targetable.EntityTargetable;
import com.ssblur.scriptor.helpers.targetable.Targetable;
import com.ssblur.scriptor.network.server.TraceNetwork;
import com.ssblur.scriptor.word.Spell;
import com.ssblur.scriptor.word.subject.InventorySubject;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J$\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0016"}, d2={"Lcom/ssblur/scriptor/word/subject/RuneSubject;", "Lcom/ssblur/scriptor/api/word/Subject;", "Lcom/ssblur/scriptor/word/subject/InventorySubject;", "<init>", "()V", "getTargets", "Ljava/util/concurrent/CompletableFuture;", "", "Lcom/ssblur/scriptor/helpers/targetable/Targetable;", "caster", "spell", "Lcom/ssblur/scriptor/word/Spell;", "cost", "Lcom/ssblur/scriptor/api/word/Word$Cost;", "castOnItem", "", "player", "Lnet/minecraft/world/entity/player/Player;", "slot", "Lnet/minecraft/world/item/ItemStack;", "canBeCastOnInventory", "", "scriptor"})
public final class RuneSubject
extends Subject
implements InventorySubject {
    @Override
    @NotNull
    public CompletableFuture<List<Targetable>> getTargets(@NotNull Targetable caster, @NotNull Spell spell) {
        Intrinsics.checkNotNullParameter((Object)caster, (String)"caster");
        Intrinsics.checkNotNullParameter((Object)spell, (String)"spell");
        CompletableFuture<List<Targetable>> result = new CompletableFuture<List<Targetable>>();
        if (caster instanceof EntityTargetable && ((EntityTargetable)caster).getTargetEntity() instanceof Player) {
            Entity entity = ((EntityTargetable)caster).getTargetEntity();
            Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.player.Player");
            Player player = (Player)entity;
            TraceNetwork.INSTANCE.requestTraceData(player, false, (Function1<? super Targetable, Unit>)((Function1)arg_0 -> RuneSubject.getTargets$lambda$0(spell, caster, player, result, arg_0)));
        } else {
            int color = CustomColors.INSTANCE.getColor(spell.deduplicatedDescriptorsForSubjects());
            BlockPos pos = caster.getTargetBlockPos();
            Level level = caster.getLevel();
            if (!level.getBlockState(pos).canBeReplaced()) {
                result.complete(CollectionsKt.emptyList());
                return result;
            }
            level.setBlockAndUpdate(pos, ((Block)ScriptorBlocks.INSTANCE.getRUNE().get()).defaultBlockState());
            BlockEntity entity = level.getBlockEntity(pos);
            if (entity instanceof RuneBlockEntity) {
                ((RuneBlockEntity)entity).setFuture(result);
                ((RuneBlockEntity)entity).setSpell(spell);
                ((RuneBlockEntity)entity).setRuneColor(color);
                ((RuneBlockEntity)entity).setChanged();
            }
        }
        return result;
    }

    @Override
    @NotNull
    public Word.Cost cost() {
        return new Word.Cost(1.0, Word.COSTTYPE.ADDITIVE);
    }

    @Override
    public void castOnItem(@NotNull Spell spell, @NotNull Player player, @NotNull ItemStack slot) {
        Intrinsics.checkNotNullParameter((Object)spell, (String)"spell");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
    }

    @Override
    public boolean canBeCastOnInventory() {
        return true;
    }

    private static final Unit getTargets$lambda$0(Spell $spell, Targetable $caster, Player $player, CompletableFuture $result, Targetable target) {
        Intrinsics.checkNotNullParameter((Object)$spell, (String)"$spell");
        Intrinsics.checkNotNullParameter((Object)$caster, (String)"$caster");
        Intrinsics.checkNotNullParameter((Object)$player, (String)"$player");
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        int color = CustomColors.INSTANCE.getColor($spell.deduplicatedDescriptorsForSubjects());
        BlockPos pos = target.getTargetBlockPos();
        Level level = $caster.getLevel();
        if (!level.getBlockState(pos).canBeReplaced()) {
            return Unit.INSTANCE;
        }
        level.setBlockAndUpdate(pos, ((Block)ScriptorBlocks.INSTANCE.getRUNE().get()).defaultBlockState());
        BlockEntity entity = level.getBlockEntity(pos);
        if (entity instanceof RuneBlockEntity) {
            ((RuneBlockEntity)entity).setOwner((Entity)$player);
            ((RuneBlockEntity)entity).setFuture($result);
            ((RuneBlockEntity)entity).setSpell($spell);
            ((RuneBlockEntity)entity).setRuneColor(color);
            ((RuneBlockEntity)entity).setChanged();
        }
        return Unit.INSTANCE;
    }
}

