/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.word.subject;

import com.ssblur.scriptor.api.word.Subject;
import com.ssblur.scriptor.api.word.Word;
import com.ssblur.scriptor.helpers.targetable.EntityTargetable;
import com.ssblur.scriptor.helpers.targetable.LecternTargetable;
import com.ssblur.scriptor.helpers.targetable.Targetable;
import com.ssblur.scriptor.network.server.TraceNetwork;
import com.ssblur.scriptor.word.Spell;
import com.ssblur.scriptor.word.descriptor.target.CollideWithWaterDescriptor;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00052\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/ssblur/scriptor/word/subject/TouchSubject;", "Lcom/ssblur/scriptor/api/word/Subject;", "<init>", "()V", "getTargets", "Ljava/util/concurrent/CompletableFuture;", "", "Lcom/ssblur/scriptor/helpers/targetable/Targetable;", "caster", "spell", "Lcom/ssblur/scriptor/word/Spell;", "cost", "Lcom/ssblur/scriptor/api/word/Word$Cost;", "scriptor"})
public final class TouchSubject
extends Subject {
    @Override
    @NotNull
    public CompletableFuture<List<Targetable>> getTargets(@NotNull Targetable caster, @NotNull Spell spell) {
        Intrinsics.checkNotNullParameter((Object)caster, (String)"caster");
        Intrinsics.checkNotNullParameter((Object)spell, (String)"spell");
        CompletableFuture<List<Targetable>> result = new CompletableFuture<List<Targetable>>();
        if (caster instanceof EntityTargetable && ((EntityTargetable)caster).getTargetEntity() instanceof Player) {
            Entity entity = ((EntityTargetable)caster).getTargetEntity();
            Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.player.Player");
            TraceNetwork.INSTANCE.requestTraceData((Player)entity, ArraysKt.contains((Object[])spell.deduplicatedDescriptorsForSubjects(), (Object)CollideWithWaterDescriptor.INSTANCE), (Function1<? super Targetable, Unit>)((Function1)arg_0 -> TouchSubject.getTargets$lambda$0(result, arg_0)));
        } else if (caster instanceof LecternTargetable) {
            BlockPos pos = caster.getTargetBlockPos().relative(caster.getFacing());
            List entities = caster.getLevel().getEntitiesOfClass(LivingEntity.class, AABB.ofSize((Vec3)new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()), (double)1.0, (double)1.0, (double)1.0));
            if (entities.isEmpty()) {
                Level level = caster.getLevel();
                Intrinsics.checkNotNull((Object)pos);
                v2 = result.complete(CollectionsKt.listOf((Object)new Targetable(level, pos)));
            } else {
                v2 = result.complete(entities.stream().map(arg_0 -> TouchSubject.getTargets$lambda$2(TouchSubject::getTargets$lambda$1, arg_0)).toList());
            }
        } else {
            result.complete(List.of(caster.simpleCopy()));
        }
        return result;
    }

    @Override
    @NotNull
    public Word.Cost cost() {
        return new Word.Cost(1.0, Word.COSTTYPE.ADDITIVE);
    }

    private static final Unit getTargets$lambda$0(CompletableFuture $result, Targetable target) {
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        $result.complete(CollectionsKt.listOf((Object)target));
        return Unit.INSTANCE;
    }

    private static final EntityTargetable getTargets$lambda$1(LivingEntity it) {
        Intrinsics.checkNotNull((Object)it);
        return new EntityTargetable((Entity)it);
    }

    private static final EntityTargetable getTargets$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (EntityTargetable)$tmp0.invoke(p0);
    }
}

