/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.tradeuses.common.mixin;

import java.util.ArrayList;
import java.util.Optional;
import me.khajiitos.tradeuses.common.config.Config;
import me.khajiitos.tradeuses.common.mixin.MerchantScreenAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.MerchantScreen;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(targets={"net.minecraft.client.gui.screens.inventory.MerchantScreen$TradeOfferButton"})
public abstract class TradeOfferButtonMixin
extends Button {
    @Final
    @Shadow(aliases={"field_19166"})
    MerchantScreen this$0;
    @Final
    @Shadow
    int index;

    protected TradeOfferButtonMixin(int $$0, int $$1, int $$2, int $$3, Component $$4, Button.OnPress $$5, Button.CreateNarration $$6) {
        super($$0, $$1, $$2, $$3, $$4, $$5, $$6);
    }

    @Inject(at={@At(value="HEAD")}, method={"renderToolTip"}, cancellable=true)
    public void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY, CallbackInfo ci) {
        MerchantMenu menu;
        int scrollOff = ((MerchantScreenAccessor)this.this$0).getScrollOff();
        if (this.index + scrollOff >= (menu = (MerchantMenu)this.this$0.getMenu()).getOffers().size()) {
            return;
        }
        Font font = Minecraft.getInstance().font;
        Minecraft minecraft = Minecraft.getInstance();
        MerchantOffer offer = (MerchantOffer)menu.getOffers().get(this.index + scrollOff);
        ArrayList<MutableComponent> tooltipList = new ArrayList<MutableComponent>();
        Optional tooltipImage = Optional.empty();
        if (this.isHovered) {
            if (mouseX < this.getX() + 20) {
                ItemStack itemStack = offer.getCostA();
                tooltipList.addAll(Screen.getTooltipFromItem((Minecraft)minecraft, (ItemStack)itemStack));
                tooltipImage = itemStack.getTooltipImage();
            } else if (mouseX < this.getX() + 50 && mouseX > this.getX() + 30) {
                ItemStack itemStack = offer.getCostB();
                if (!itemStack.isEmpty()) {
                    tooltipList.addAll(Screen.getTooltipFromItem((Minecraft)minecraft, (ItemStack)itemStack));
                    tooltipImage = itemStack.getTooltipImage();
                }
            } else if (mouseX > this.getX() + 65) {
                ItemStack itemStack = offer.getResult();
                tooltipList.addAll(Screen.getTooltipFromItem((Minecraft)minecraft, (ItemStack)itemStack));
                tooltipImage = itemStack.getTooltipImage();
            }
            if (!tooltipList.isEmpty()) {
                tooltipList.add(Component.empty());
            }
            Config.getDisplayLines().forEach(line -> tooltipList.add(Component.literal((String)line.replace("{uses_left}", String.valueOf(Math.max(0, offer.getMaxUses() - offer.getUses()))).replace("{uses}", String.valueOf(offer.getUses())).replace("{max_uses}", String.valueOf(offer.getMaxUses())))));
            guiGraphics.setTooltipForNextFrame(font, tooltipList, tooltipImage, mouseX, mouseY, (ResourceLocation)offer.getResult().get(DataComponents.TOOLTIP_STYLE));
        }
        ci.cancel();
    }
}

