/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.tradeuses.common.screen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Optional;
import joptsimple.internal.Strings;
import me.khajiitos.tradeuses.common.config.Config;
import me.khajiitos.tradeuses.common.screen.widget.EditBoxParagraphAllowed;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;

public class ConfigScreen
extends Screen {
    private EditBoxParagraphAllowed editBox;
    private Button copyColorCodeButton;
    private final Screen parent;
    private final String originalValue;
    private int ticksUntilButtonRenamed;

    public ConfigScreen(Screen parent) {
        super((Component)Component.translatable((String)"tradeuses.tradeuses_config"));
        this.parent = parent;
        this.originalValue = Config.lines.isEmpty() ? I18n.get((String)"tradeuses.default_tooltip", (Object[])new Object[0]) : Strings.join(Config.lines, (String)"\\n");
    }

    public ConfigScreen(Minecraft minecraft, Screen parent) {
        this(parent);
        this.minecraft = minecraft;
    }

    protected void init() {
        String value = this.editBox != null ? this.editBox.getValue() : this.originalValue;
        this.editBox = (EditBoxParagraphAllowed)this.addRenderableWidget((GuiEventListener)new EditBoxParagraphAllowed(Minecraft.getInstance().font, this.width / 2 - 100, this.height / 2 - 10, 200, 20, (Component)Component.translatable((String)"tradeuses.tooltip_text")));
        this.editBox.setFormatter((text, i) -> FormattedCharSequence.forward((String)text, (Style)Style.EMPTY.withItalic(Boolean.valueOf(this.editBox.getValue().equals(I18n.get((String)"tradeuses.default_tooltip", (Object[])new Object[0]))))));
        this.editBox.setMaxLength(256);
        this.editBox.setValue(value);
        this.setInitialFocus((GuiEventListener)this.editBox);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, button -> this.onClose()).bounds(this.width / 2 - 100, this.height - 27, 200, 20).build());
        this.copyColorCodeButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"tradeuses.copy_color_code_char"), button -> {
            if (this.minecraft != null) {
                this.minecraft.keyboardHandler.setClipboard("\u00a7");
                button.setMessage((Component)Component.translatable((String)"tradeuses.copied"));
                this.ticksUntilButtonRenamed = 30;
            }
        }).bounds(this.width / 2 - 100, this.height / 2 + 15, 200, 20).build());
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"tradeuses.placeholders"), 3, 3, -7829368);
        ArrayList<MutableComponent> preview = new ArrayList<MutableComponent>();
        for (String line : this.editBox.getValue().split("\\\\n")) {
            preview.add(Component.literal((String)line.replace("{uses}", "0").replace("{max_uses}", "12").replace("{uses_left}", "12")));
        }
        int tooltipWidth = preview.stream().map(arg_0 -> ((Font)this.font).width(arg_0)).max(Comparator.comparingInt(value -> value)).orElse(0) + 8;
        int tooltipHeight = preview.size() * 10 + 10 + (preview.size() >= 2 ? 2 : 0);
        guiGraphics.drawCenteredString(this.font, (Component)Component.translatable((String)"tradeuses.preview"), this.width / 2, this.height / 2 - tooltipHeight - 32, -1);
        guiGraphics.setTooltipForNextFrame(this.font, preview, Optional.empty(), (this.width - tooltipWidth) / 2 - 8, this.height / 2 - tooltipHeight - 5);
    }

    public void tick() {
        if (this.ticksUntilButtonRenamed > 0 && --this.ticksUntilButtonRenamed == 0) {
            this.copyColorCodeButton.setMessage((Component)Component.translatable((String)"tradeuses.copy_color_code_char"));
        }
    }

    public void onClose() {
        if (this.minecraft != null) {
            this.minecraft.setScreen(this.parent);
        }
        if (!this.originalValue.equals(this.editBox.getValue())) {
            Config.lines.clear();
            if (!this.editBox.getValue().isEmpty() && !this.editBox.getValue().equals(I18n.get((String)"tradeuses.default_tooltip", (Object[])new Object[0]))) {
                Config.lines.addAll(Arrays.asList(this.editBox.getValue().split("\\\\n")));
            }
            Config.save();
        }
    }
}

