/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.tradeuses.common.screen.widget;

import me.khajiitos.tradeuses.common.mixin.EditBoxAccessor;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringUtil;
import org.jetbrains.annotations.NotNull;

public class EditBoxParagraphAllowed
extends EditBox {
    public EditBoxParagraphAllowed(Font font, int x, int y, int w, int h, Component text) {
        super(font, x, y, w, h, text);
    }

    public boolean keyPressed(int key, int idk, int idk2) {
        if (key == 257 && this.canConsumeInput()) {
            this.insertText("\\n");
            return true;
        }
        return super.keyPressed(key, idk, idk2);
    }

    private String filterText(String str) {
        StringBuilder stringBuilder = new StringBuilder();
        for (char c : str.toCharArray()) {
            if (c != '\u00a7' && !StringUtil.isAllowedChatCharacter((char)c)) continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public boolean charTyped(char c, int i) {
        if (!this.canConsumeInput()) {
            return false;
        }
        if (c == '\u00a7' || StringUtil.isAllowedChatCharacter((char)c)) {
            this.insertText(Character.toString(c));
            return true;
        }
        return false;
    }

    public void insertText(@NotNull String str) {
        String filteredText;
        int filteredTextLength;
        EditBoxAccessor accessor = (EditBoxAccessor)((Object)this);
        int selectionStart = Math.min(accessor.getCursorPos(), accessor.getHighlightPos());
        int selectionEnd = Math.max(accessor.getCursorPos(), accessor.getHighlightPos());
        int idk = accessor.getMaxLength() - accessor.getValue().length() - (selectionStart - selectionEnd);
        if (idk < (filteredTextLength = (filteredText = this.filterText(str)).length())) {
            filteredText = filteredText.substring(0, idk);
            filteredTextLength = idk;
        }
        String newValue = new StringBuilder(accessor.getValue()).replace(selectionStart, selectionEnd, filteredText).toString();
        if (accessor.getFilter().test(newValue)) {
            accessor.callSetValue(newValue);
            this.setCursorPosition(selectionStart + filteredTextLength);
            this.setHighlightPos(accessor.getCursorPos());
            accessor.callOnValueChange(accessor.getValue());
        }
    }
}

