/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity;

import com.ovinter.mythsandlegends.Config;
import com.ovinter.mythsandlegends.api.util.ParticleGeneratorHelper;
import com.ovinter.mythsandlegends.config.DefaultMobAttributes;
import com.ovinter.mythsandlegends.entity.MLEntity;
import com.ovinter.mythsandlegends.entity.ai.goal.abaddon.MoltenSpikesGoal;
import com.ovinter.mythsandlegends.entity.ai.goal.generic.AnimatedMeleeAttackGoal;
import com.ovinter.mythsandlegends.entity.ai.goal.generic.ChaseTargetGoal;
import com.ovinter.mythsandlegends.registry.MLSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class AbaddonEntity
extends MLEntity {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final RawAnimation IDLE_ANIM = RawAnimation.begin().thenLoop("IDLE");
    private final RawAnimation WALK_ANIM = RawAnimation.begin().thenLoop("WALK");
    private final RawAnimation ATTACK_ANIM = RawAnimation.begin().thenPlay("ATTACK");
    private final RawAnimation RANGED_ATTACK_ANIM = RawAnimation.begin().thenPlay("RANGED_ATTACK");
    private final RawAnimation DEATH_ANIM = RawAnimation.begin().thenPlay("DEATH");
    public int moltenSpikeCooldown;
    public final int MOLTEN_SPIKE_COOLDOWN = 200;

    public AbaddonEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.LAVA, 0.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, DefaultMobAttributes.ABADDON_HEALTH).m_22268_(Attributes.f_22284_, DefaultMobAttributes.ABADDON_ARMOR).m_22268_(Attributes.f_22281_, DefaultMobAttributes.ABADDON_DAMAGE).m_22268_(Attributes.f_22279_, DefaultMobAttributes.ABADDON_MOVEMENT).m_22268_(Attributes.f_22277_, DefaultMobAttributes.ABADDON_FOLLOW_RANGE);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(4, (Goal)new MoltenSpikesGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new AnimatedMeleeAttackGoal(this, 20, 8, 3.0f));
        this.f_21345_.m_25352_(5, (Goal)new ChaseTargetGoal(this, false, 1.2));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 12.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractPiglin.class, true));
    }

    public void m_8119_() {
        if (this.moltenSpikeCooldown > 0) {
            --this.moltenSpikeCooldown;
        }
        this.floatAbaddon();
        this.m_20101_();
        if (this.m_9236_().f_46443_ && this.getAnimationId() == 2) {
            ParticleGeneratorHelper.generateCircleParticles(this.m_9236_(), (LivingEntity)this, ParticleTypes.f_175834_, 0.3, 1.2);
        }
        super.m_8119_();
    }

    protected void m_8024_() {
        if (this.getAttackTicks() > 0) {
            this.setAttackTicks(this.getAttackTicks() - 1);
        }
        super.m_8024_();
    }

    public boolean m_7327_(Entity pEntity) {
        boolean success = super.m_7327_(pEntity);
        if (success) {
            this.playAttackSound();
        }
        return success;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.setConfigAttributes();
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public boolean m_7307_(Entity entity) {
        if (entity == this) {
            return true;
        }
        if (entity.getClass() == this.getClass()) {
            return true;
        }
        return super.m_7307_(entity);
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean m_5825_() {
        return true;
    }

    public boolean m_6126_() {
        return true;
    }

    public boolean m_203441_(FluidState pFluidState) {
        return pFluidState.m_205070_(FluidTags.f_13132_);
    }

    public boolean m_142535_(float fallDistance, float multiplier, DamageSource source) {
        return false;
    }

    public float m_5610_(BlockPos pos, LevelReader level) {
        if (level.m_8055_(pos).m_60819_().m_205070_(FluidTags.f_13132_)) {
            return 10.0f;
        }
        return this.m_20077_() ? Float.NEGATIVE_INFINITY : 0.0f;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)MLSounds.ABADDON_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)MLSounds.ABADDON_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)MLSounds.ABADDON_DEATH.get();
    }

    private void playAttackSound() {
        this.m_216990_((SoundEvent)MLSounds.ABADDON_ATTACK.get());
    }

    @Override
    PlayState movementPredicate(AnimationState<?> state) {
        if (this.m_21224_()) {
            return state.setAndContinue(this.DEATH_ANIM);
        }
        if (this.getAnimationId() == 2) {
            return state.setAndContinue(this.RANGED_ATTACK_ANIM);
        }
        return state.isMoving() ? state.setAndContinue(this.WALK_ANIM) : state.setAndContinue(this.IDLE_ANIM);
    }

    @Override
    PlayState attackPredicate(AnimationState<?> state) {
        if (this.m_21224_()) {
            return PlayState.STOP;
        }
        if (this.getAnimationId() == 1 && this.getAttackTicks() == 19 && this.m_6084_()) {
            state.getController().forceAnimationReset();
            return state.setAndContinue(this.ATTACK_ANIM);
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movementController", 5, this::movementPredicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackController", 2, this::attackPredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    @Override
    void setConfigAttributes() {
        this.m_21051_(Attributes.f_22276_).m_22100_(((Double)Config.ABADDON_HEALTH.get()).doubleValue());
        this.m_21051_(Attributes.f_22284_).m_22100_(((Double)Config.ABADDON_ARMOR.get()).doubleValue());
        this.m_21051_(Attributes.f_22281_).m_22100_(((Double)Config.ABADDON_DAMAGE.get()).doubleValue());
        this.m_21153_((float)((Double)Config.SCORCHED_SENTINEL_HEALTH.get()).doubleValue());
    }

    private void floatAbaddon() {
        if (this.m_20077_()) {
            CollisionContext collisioncontext = CollisionContext.m_82750_((Entity)this);
            if (collisioncontext.m_6513_(LiquidBlock.f_54690_, this.m_20183_(), true) && !this.m_9236_().m_6425_(this.m_20183_().m_7494_()).m_205070_(FluidTags.f_13132_)) {
                this.m_6853_(true);
            } else {
                this.m_20256_(this.m_20184_().m_82490_(0.5).m_82520_(0.0, 0.05, 0.0));
            }
        }
    }
}

