/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity;

import com.ovinter.mythsandlegends.Config;
import com.ovinter.mythsandlegends.api.util.ParticleGeneratorHelper;
import com.ovinter.mythsandlegends.config.DefaultMobAttributes;
import com.ovinter.mythsandlegends.entity.BlackCharroEntity;
import com.ovinter.mythsandlegends.entity.MLEntity;
import com.ovinter.mythsandlegends.entity.ai.goal.generic.AnimatedMeleeAttackGoal;
import com.ovinter.mythsandlegends.entity.ai.goal.generic.ChaseTargetGoal;
import com.ovinter.mythsandlegends.registry.MLSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class CondemnedEntity
extends MLEntity {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final RawAnimation SPAWN = RawAnimation.begin().thenPlay("SPAWN");
    private final RawAnimation IDLE = RawAnimation.begin().thenLoop("IDLE");
    private final RawAnimation WALK = RawAnimation.begin().thenLoop("WALK");
    private final RawAnimation ATTACK = RawAnimation.begin().thenPlay("ATTACK");
    private final RawAnimation DEATH = RawAnimation.begin().thenPlay("DEATH");
    private static final EntityDataAccessor<Integer> DATA_SPAWN_TICKS = SynchedEntityData.m_135353_(CondemnedEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public CondemnedEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, DefaultMobAttributes.CONDEMNED_HEALTH).m_22268_(Attributes.f_22279_, DefaultMobAttributes.CONDEMNED_MOVEMENT).m_22268_(Attributes.f_22277_, DefaultMobAttributes.CONDEMNED_FOLLOW_RANGE).m_22268_(Attributes.f_22281_, DefaultMobAttributes.CONDEMNED_DAMAGE);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new RestrictSunGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(5, (Goal)new FleeSunGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new AnimatedMeleeAttackGoal(this, 20, 3, 2.5f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && CondemnedEntity.this.getSpawnTicks() == 0;
            }
        });
        this.f_21345_.m_25352_(6, (Goal)new ChaseTargetGoal(this, false, 1.2));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 12.0f));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{CondemnedEntity.class}));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_SPAWN_TICKS, (Object)40);
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("SpawnTicks", this.getSpawnTicks());
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setSpawnTimer(pCompound.m_128451_("SpawnTicks"));
    }

    public void m_8119_() {
        if (this.getSpawnTicks() > 0 && this.m_9236_().m_5776_()) {
            ParticleGeneratorHelper.generateEntitySpawnFromGroundParticles(this.m_9236_(), (LivingEntity)this);
        }
        super.m_8119_();
    }

    protected void m_8024_() {
        if (this.getSpawnTicks() > 0) {
            this.setSpawnTimer(this.getSpawnTicks() - 1);
        }
        if (this.getAttackTicks() > 0) {
            this.setAttackTicks(this.getAttackTicks() - 1);
        }
        super.m_8024_();
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 15 && !this.m_9236_().m_5776_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        super.m_6153_();
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.setConfigAttributes();
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)MLSounds.CONDEMNED_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)MLSounds.CONDEMNED_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)MLSounds.CONDEMNED_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
    }

    public void m_8107_() {
        boolean flag = this.m_21527_();
        if (flag) {
            this.m_20254_(2);
        }
        super.m_8107_();
    }

    public boolean m_6060_() {
        return super.m_6060_() && this.getSpawnTicks() == 0;
    }

    public boolean m_7307_(Entity entity) {
        if (entity == this) {
            return true;
        }
        if (entity.getClass() == this.getClass()) {
            return true;
        }
        if (entity instanceof BlackCharroEntity) {
            return true;
        }
        return super.m_7307_(entity);
    }

    public void m_7023_(Vec3 pTravelVector) {
        if (this.getSpawnTicks() > 0) {
            if (this.m_21573_().m_26570_() != null) {
                this.m_21573_().m_26573_();
            }
            super.m_7023_(Vec3.f_82478_);
            return;
        }
        super.m_7023_(pTravelVector);
    }

    public boolean m_20147_() {
        return this.getSpawnTicks() > 0;
    }

    public boolean m_6673_(DamageSource pSource) {
        return this.getSpawnTicks() > 0 || pSource.m_269533_(DamageTypeTags.f_268415_);
    }

    public void setSpawnTimer(int pSpawnTimer) {
        this.m_20088_().m_135381_(DATA_SPAWN_TICKS, (Object)pSpawnTimer);
    }

    public int getSpawnTicks() {
        return (Integer)this.m_20088_().m_135370_(DATA_SPAWN_TICKS);
    }

    @Override
    PlayState movementPredicate(AnimationState<?> state) {
        if (this.getSpawnTicks() > 0) {
            return state.setAndContinue(this.SPAWN);
        }
        return state.isMoving() && this.getSpawnTicks() <= 0 ? state.setAndContinue(this.WALK) : state.setAndContinue(this.IDLE);
    }

    @Override
    PlayState attackPredicate(AnimationState<?> state) {
        if (this.getAnimationId() == 1 && this.getAttackTicks() == 19 && this.m_6084_() && this.getSpawnTicks() == 0) {
            state.getController().forceAnimationReset();
            return state.setAndContinue(this.ATTACK);
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::movementPredicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "deathController", 0, state -> {
            if (this.m_21224_() || (double)this.m_21223_() < 0.01) {
                state.getController().setAnimation(this.DEATH);
            }
            return PlayState.CONTINUE;
        })});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackController", 2, this::attackPredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    @Override
    void setConfigAttributes() {
        this.m_21051_(Attributes.f_22276_).m_22100_(((Double)Config.CONDEMNED_HEALTH.get()).doubleValue());
        this.m_21051_(Attributes.f_22281_).m_22100_(((Double)Config.CONDEMNED_DAMAGE.get()).doubleValue());
        this.m_21153_((float)((Double)Config.CONDEMNED_HEALTH.get()).doubleValue());
    }
}

