/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity.projectile;

import com.ovinter.mythsandlegends.registry.MLEntities;
import com.ovinter.mythsandlegends.registry.MLSounds;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fluids.FluidType;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ShadowHorseEntity
extends Entity
implements GeoEntity {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final RawAnimation RUN = RawAnimation.begin().thenLoop("RUN");
    private UUID ownerUUID;
    private final int LIFESPAN_TICKS = 150;
    private int lifeTicks;

    public ShadowHorseEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public ShadowHorseEntity(Level world, LivingEntity shooter) {
        this((EntityType)MLEntities.SHADOW_HORSE.get(), world);
        this.m_6034_(shooter.m_20185_(), shooter.m_20188_(), shooter.m_20189_());
        this.setOwner(shooter);
        this.f_19794_ = true;
        this.lifeTicks = 150;
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128403_("Owner")) {
            this.ownerUUID = compound.m_128342_("Owner");
        }
    }

    protected void m_7380_(CompoundTag compound) {
        if (this.ownerUUID != null) {
            compound.m_128362_("Owner", this.ownerUUID);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            this.m_20256_(this.m_20184_());
            this.m_6478_(MoverType.SELF, this.m_20184_());
            AABB hitbox = this.m_20191_().m_82400_(0.3);
            for (Player player : this.m_9236_().m_45976_(Player.class, hitbox)) {
                if (player.equals((Object)this.ownerUUID)) continue;
                player.m_6469_(this.m_269291_().m_269425_(), 4.0f);
                this.spawnExplosionEffect();
                this.m_146870_();
                return;
            }
            if (--this.lifeTicks <= 0) {
                this.spawnExplosionEffect();
                this.m_146870_();
            }
        }
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    public void setOwner(LivingEntity pOwner) {
        this.ownerUUID = pOwner.m_20148_();
    }

    public LivingEntity getOwner() {
        if (this.ownerUUID == null) {
            return null;
        }
        Entity entity = ((ServerLevel)this.m_9236_()).m_8791_(this.ownerUUID);
        return entity instanceof LivingEntity ? (LivingEntity)entity : null;
    }

    PlayState predicate(AnimationState<?> state) {
        return state.setAndContinue(this.RUN);
    }

    private void spawnExplosionEffect() {
        ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 15, 0.4, 0.4, 0.4, 0.01);
        this.m_5496_((SoundEvent)MLSounds.UMBRAL_DOOM_ORB_EXPLOSION.get(), 5.0f, 1.0f);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }
}

