/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.event;

import com.mojang.blaze3d.shaders.FogShape;
import com.ovinter.mythsandlegends.client.gui.BossBar;
import com.ovinter.mythsandlegends.client.render.layer.player.ArmorFirstPersonRenderer;
import com.ovinter.mythsandlegends.entity.BlackCharroEntity;
import com.ovinter.mythsandlegends.entity.effects.EffectScreenShake;
import com.ovinter.mythsandlegends.registry.MLEffects;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.LerpingBossEvent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="mythsandlegends", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class EventBusClientEvents {
    private static final ResourceLocation BAR_BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)"textures/gui/sprites/bar/background.png");

    @SubscribeEvent
    public static void onCameraSetup(ViewportEvent.ComputeCameraAngles event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        float delta = Minecraft.m_91087_().m_91296_();
        float ticksExistedDelta = (float)player.f_19797_ + delta;
        if (player != null) {
            float shakeAmplitude = 0.0f;
            for (EffectScreenShake ScreenShake : player.m_9236_().m_45976_(EffectScreenShake.class, player.m_20191_().m_82377_(20.0, 20.0, 20.0))) {
                if (ScreenShake.m_20270_((Entity)player) < ScreenShake.getRadius()) {
                    shakeAmplitude += ScreenShake.getShakeAmount((Player)player, delta);
                }
                if (shakeAmplitude > 1.0f) {
                    shakeAmplitude = 1.0f;
                }
                event.setPitch((float)((double)event.getPitch() + (double)shakeAmplitude * Math.cos(ticksExistedDelta * 3.0f + 2.0f) * 25.0));
                event.setYaw((float)((double)event.getYaw() + (double)shakeAmplitude * Math.cos(ticksExistedDelta * 5.0f + 1.0f) * 25.0));
                event.setRoll((float)((double)event.getRoll() + (double)shakeAmplitude * Math.cos(ticksExistedDelta * 4.0f) * 25.0));
            }
        }
    }

    @SubscribeEvent
    public static void onTick(TickEvent.ClientTickEvent event) {
        if (!EventBusClientEvents.isGameActive()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        ArmorFirstPersonRenderer.clientTick(player);
        if (player.m_21023_((MobEffect)MLEffects.PETRIFIED.get())) {
            mc.f_91066_.f_92085_.m_7249_(false);
            mc.f_91066_.f_92087_.m_7249_(false);
            mc.f_91066_.f_92086_.m_7249_(false);
            mc.f_91066_.f_92088_.m_7249_(false);
            mc.f_91066_.f_92090_.m_7249_(false);
            mc.f_91066_.f_92089_.m_7249_(false);
        }
    }

    @SubscribeEvent
    public static void onMouseInput(InputEvent.InteractionKeyMappingTriggered event) {
        if (EventBusClientEvents.shouldBlockInputs()) {
            event.setSwingHand(false);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRenderFog(ViewportEvent.RenderFog event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ != null && mc.f_91074_ != null) {
            List nearbyBosses;
            Entity cameraEntity = mc.f_91075_;
            if (cameraEntity == null) {
                return;
            }
            if (mc.f_91073_.m_46472_().m_135782_().m_135815_().equals("overworld") && !(nearbyBosses = mc.f_91073_.m_6249_(cameraEntity, cameraEntity.m_20191_().m_82400_(30.0), entity -> {
                BlackCharroEntity boss;
                return entity instanceof BlackCharroEntity && (boss = (BlackCharroEntity)((Object)entity)).m_6084_();
            })).isEmpty()) {
                event.setNearPlaneDistance(2.5f);
                event.setFarPlaneDistance(15.0f);
                event.setFogShape(FogShape.SPHERE);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onRenderFogColor(ViewportEvent.ComputeFogColor event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ != null && mc.f_91074_ != null) {
            Entity cameraEntity = mc.f_91075_;
            if (cameraEntity == null) {
                return;
            }
            boolean inOverworld = mc.f_91073_.m_46472_().m_135782_().m_135815_().equals("overworld");
            List nearbyBosses = mc.f_91073_.m_6249_(cameraEntity, cameraEntity.m_20191_().m_82400_(30.0), entity -> {
                BlackCharroEntity boss;
                return entity instanceof BlackCharroEntity && (boss = (BlackCharroEntity)((Object)entity)).m_6084_();
            });
            if (inOverworld && !nearbyBosses.isEmpty()) {
                event.setRed(0.0f);
                event.setGreen(0.0f);
                event.setBlue(0.0f);
            }
        }
    }

    @SubscribeEvent
    public static void onCustomGuiOverlay(CustomizeGuiOverlayEvent.BossEventProgress event) {
        LerpingBossEvent bossEvent = event.getBossEvent();
        String bossName = bossEvent.m_18861_().getString();
        BossBar bossBar = BossBar.bossBarMap.get(bossName);
        if (bossBar != null) {
            event.setCanceled(true);
            EventBusClientEvents.prepareBossBar(event, bossBar);
        }
    }

    private static void prepareBossBar(CustomizeGuiOverlayEvent.BossEventProgress event, BossBar BossBar2) {
        event.setIncrement(BossBar2.getIncrement());
        EventBusClientEvents.renderHealthBar(event, BossBar2.getBarHealthOffsetX(), event.getY() + BossBar2.getBarHealthPosY() - 12, BossBar2.getBarHealthWidth(), BossBar2.getBarHealthHeight(), BossBar2.getBarColor());
        EventBusClientEvents.renderBarOverlay(event.getY() + BossBar2.getBarOverlayPosY() - 12, BossBar2.getBarOverlayWidth(), BossBar2.getBarOverlayHeight(), BossBar2.getBarOverlay());
    }

    private static void renderHealthBar(CustomizeGuiOverlayEvent.BossEventProgress event, int OffsetX, int y, int Width, int Height, ResourceLocation barColor) {
        LerpingBossEvent bossEvent = event.getBossEvent();
        int x = (Minecraft.m_91087_().m_91268_().m_85445_() - Width) / 2 + OffsetX;
        Minecraft minecraft = Minecraft.m_91087_();
        MultiBufferSource.BufferSource bufferSource = minecraft.m_91269_().m_110104_();
        GuiGraphics guiGraphics = new GuiGraphics(minecraft, bufferSource);
        guiGraphics.m_280163_(BAR_BACKGROUND, x, y, 0.0f, 0.0f, Width, Height, Width, Height);
        if (bossEvent.m_142717_() > 0.0f) {
            guiGraphics.m_280163_(barColor, x, y, 0.0f, 0.0f, (int)(bossEvent.m_142717_() * (float)Width), Height, Width, Height);
        }
    }

    public static void renderBarOverlay(int y, int Width, int Height, ResourceLocation BOSS_TEXTURE) {
        Minecraft minecraft = Minecraft.m_91087_();
        MultiBufferSource.BufferSource bufferSource = minecraft.m_91269_().m_110104_();
        GuiGraphics guiGraphics = new GuiGraphics(minecraft, bufferSource);
        int x = (minecraft.m_91268_().m_85445_() - Width) / 2;
        guiGraphics.m_280163_(BOSS_TEXTURE, x, y, 0.0f, 0.0f, Width, Height, Width, Height);
    }

    public static boolean isGameActive() {
        return Minecraft.m_91087_().f_91073_ != null && Minecraft.m_91087_().f_91074_ != null;
    }

    private static boolean shouldBlockInputs() {
        Minecraft mc = Minecraft.m_91087_();
        return mc.f_91074_ != null && mc.f_91074_.m_21023_((MobEffect)MLEffects.PETRIFIED.get());
    }
}

