/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.event;

import com.ovinter.mythsandlegends.api.util.SendMessageToPlayer;
import com.ovinter.mythsandlegends.datagen.tags.MLEntityTypeTag;
import com.ovinter.mythsandlegends.entity.BlackCharroEntity;
import com.ovinter.mythsandlegends.registry.MLEffects;
import com.ovinter.mythsandlegends.registry.MLItems;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;

@Mod.EventBusSubscriber(modid="mythsandlegends", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EventBusServerEvents {
    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            DamageSource damageSource = event.getSource();
            if (damageSource.m_7639_() instanceof BlackCharroEntity) {
                SendMessageToPlayer.sendRandomMessage("kills_player", player, 5);
            }
        }
    }

    @SubscribeEvent
    public static void onAttackEntity(AttackEntityEvent event) {
        Player attacker = event.getEntity();
        if (attacker.m_21023_((MobEffect)MLEffects.PETRIFIED.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBlockDamage(LivingAttackEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Entity attacker;
            Player player = (Player)livingEntity;
            if (!player.m_21254_()) {
                return;
            }
            ItemStack shieldItem = player.m_21211_();
            if (shieldItem.m_41720_() != MLItems.MALEDICTUM_SHIELD.get()) {
                return;
            }
            if (player.m_217043_().m_188501_() < 0.25f && (attacker = event.getSource().m_7639_()) instanceof LivingEntity) {
                LivingEntity livingAttacker = (LivingEntity)attacker;
                livingAttacker.m_20254_(3);
            }
        }
    }

    @SubscribeEvent
    public static void onSetTarget(LivingChangeTargetEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.m_21023_((MobEffect)MLEffects.PETRIFIED.get())) {
            event.setNewTarget(null);
        }
    }

    @SubscribeEvent
    public static void onPlayerHurt(LivingHurtEvent event) {
        boolean isNetherVariant;
        DamageSource source = event.getSource();
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        Entity entity = source.m_7639_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)entity;
        boolean isNetherMob = attacker.m_6095_().m_204039_(MLEntityTypeTag.EntityTypes.NETHER_MOBS);
        boolean isPossessedArmorMob = attacker.m_6095_().m_204039_(MLEntityTypeTag.EntityTypes.POSSESSED_ARMORS);
        boolean bl = isNetherVariant = attacker.getPersistentData().m_128451_("Variant") == 1;
        if (!(isNetherMob || isNetherVariant || isPossessedArmorMob)) {
            return;
        }
        boolean hasRelic = false;
        float reducedDamage = 0.0f;
        if (CuriosApi.getCuriosInventory((LivingEntity)player).map(curiosInventory -> curiosInventory.findFirstCurio((Item)MLItems.ANTIQUE_EMBLEM.get())).isPresent()) {
            hasRelic = true;
            reducedDamage = event.getAmount() * 0.75f;
        } else if (CuriosApi.getCuriosInventory((LivingEntity)player).map(curiosInventory -> curiosInventory.findFirstCurio((Item)MLItems.SVAROGS_RING.get())).isPresent()) {
            hasRelic = true;
            reducedDamage = event.getAmount() * 0.8f;
        } else {
            for (ItemStack stack : player.m_150109_().f_35974_) {
                if (!EventBusServerEvents.getRelicItem(stack.m_41720_())) continue;
                hasRelic = true;
                break;
            }
        }
        if (hasRelic) {
            event.setAmount(reducedDamage);
        }
    }

    @SubscribeEvent
    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (CuriosApi.getCuriosInventory((LivingEntity)player).map(curiosInventory -> curiosInventory.findFirstCurio((Item)MLItems.SVAROGS_RING.get())).isPresent() && player.m_9236_().m_46472_() == Level.f_46429_) {
            SendMessageToPlayer.displayClientMessage((Component)Component.m_237113_((String)"The Abyss answers your call...").m_130940_(ChatFormatting.DARK_PURPLE), player, true);
        }
    }

    private static boolean getRelicItem(Item pItem) {
        return pItem == MLItems.ANTIQUE_EMBLEM.get() || pItem == MLItems.SVAROGS_RING.get();
    }
}

