/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.item.custom;

import com.ovinter.mythsandlegends.client.render.item.MoltenFistRenderer;
import com.ovinter.mythsandlegends.entity.effects.MoltenThornEntity;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MoltenFistItem
extends SwordItem
implements GeoItem,
GeoAnimatable {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final RawAnimation IDLE = RawAnimation.begin().thenLoop("IDLE");
    private final RawAnimation ATTACK = RawAnimation.begin().thenPlay("ATTACK");
    private final RawAnimation ABILITY = RawAnimation.begin().thenPlay("ABILITY");
    private int TOTAL_FANGS = 8;
    private double BURN_CHANCE = 0.2;

    public MoltenFistItem(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, Item.Properties pProperties) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, pProperties.m_41486_().m_41497_(Rarity.RARE));
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private MoltenFistRenderer renderer;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new MoltenFistRenderer();
                }
                return this.renderer;
            }
        });
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        if (player.m_20096_()) {
            Level level2 = player.m_9236_();
            if (level2 instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level2;
                this.triggerAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)player.m_21120_(usedHand), (ServerLevel)serverLevel), "attackController", "shoot");
            }
            player.m_36335_().m_41524_((Item)this, 30);
            for (int i = 0; i < this.TOTAL_FANGS; ++i) {
                this.spawnThorn(i, (LivingEntity)player);
            }
            return ItemUtils.m_150959_((Level)level, (Player)player, (InteractionHand)usedHand);
        }
        return super.m_7203_(level, player, usedHand);
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.triggerAnim((Entity)entity, GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)serverLevel), "attackController", "attack");
        }
        return super.onEntitySwing(stack, entity);
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        if (player.m_217043_().m_188500_() < this.BURN_CHANCE) {
            entity.m_20254_(2);
        }
        return super.onLeftClickEntity(stack, player, entity);
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        if (Screen.m_96638_()) {
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.mythsandlegends.blazing_fist_tooltip"));
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.mythsandlegends.blazing_fist_tooltip2"));
        } else {
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.mythsandlegends.blazing_fist"));
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.mythsandlegends.more_info"));
        }
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    private void spawnThorn(int pIndex, LivingEntity pPlayer) {
        int lowestYCheck = Mth.m_14107_((double)pPlayer.m_20186_()) - 1;
        double y = pPlayer.m_20186_() + 1.0;
        float yawRadians = (float)Math.toRadians(90.0f + pPlayer.m_146908_());
        double distance = 1.5 + (double)pIndex * 1.25;
        int warmUpDelayTicks = pIndex * 2;
        double x = pPlayer.m_20185_() + (double)Mth.m_14089_((float)yawRadians) * distance;
        double z = pPlayer.m_20189_() + (double)Mth.m_14031_((float)yawRadians) * distance;
        BlockPos blockPos = BlockPos.m_274561_((double)x, (double)y, (double)z);
        boolean foundGround = false;
        double d0 = 0.0;
        do {
            BlockState blockState1;
            VoxelShape voxelShape;
            BlockPos blockPos1 = blockPos.m_7495_();
            BlockState blockState = pPlayer.m_9236_().m_8055_(blockPos1);
            if (!blockState.m_60783_((BlockGetter)pPlayer.m_9236_(), blockPos1, Direction.UP)) continue;
            if (!pPlayer.m_9236_().m_46859_(blockPos) && !(voxelShape = (blockState1 = pPlayer.m_9236_().m_8055_(blockPos)).m_60812_((BlockGetter)pPlayer.m_9236_(), blockPos)).m_83281_()) {
                d0 = voxelShape.m_83297_(Direction.Axis.Y);
            }
            foundGround = true;
            break;
        } while ((blockPos = blockPos.m_7495_()).m_123342_() >= lowestYCheck);
        if (foundGround) {
            MoltenThornEntity thornEntity = new MoltenThornEntity(pPlayer.m_9236_(), x, (double)blockPos.m_123342_() + d0, z, yawRadians, warmUpDelayTicks, 4.0f, pPlayer);
            pPlayer.m_9236_().m_7967_((Entity)thornEntity);
        }
    }

    PlayState predicate(AnimationState<?> state) {
        return state.setAndContinue(this.IDLE);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 3, this::predicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackController", 3, state -> PlayState.STOP).triggerableAnim("attack", this.ATTACK).triggerableAnim("shoot", this.ABILITY)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }
}

