/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.api.util;

import com.ovinter.mythsandlegends.registry.MLParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Vector3f;

public class ParticleGenerator {
    private static double rotationAngle = 0.0;

    public static void generateDustParticles(Entity pEntity, float pRed, float pGreen, float pBlue, float pAmount, boolean isCustomYNeeded, boolean isEyeHeight, double pXSpeed, double pYSpeed, double pZSpeed) {
        Vector3f color = new Vector3f(pRed, pGreen, pBlue);
        DustParticleOptions particles = new DustParticleOptions(color, pAmount);
        double y = isCustomYNeeded ? (isEyeHeight ? pEntity.getEyeY() : (double)pEntity.getBbHeight()) : pEntity.getY();
        for (int i = 0; i < 3; ++i) {
            double x = pEntity.getX() + (pEntity.getRandom().nextDouble() - 0.5) * 1.0;
            double z = pEntity.getZ() + (pEntity.getRandom().nextDouble() - 0.5) * 1.0;
            pEntity.level().addParticle((ParticleOptions)particles, x, y, z, pXSpeed, pYSpeed, pZSpeed);
        }
    }

    public static void generateParticles(Entity pEntity, int pParticleCount, SimpleParticleType pType, boolean isCustomYNeeded, boolean isEyeHeight, double pXSpeed, double pYSpeed, double pZSpeed) {
        double y = isCustomYNeeded ? (isEyeHeight ? pEntity.getEyeY() : (double)pEntity.getBbHeight()) : pEntity.getY();
        for (int i = 0; i < pParticleCount; ++i) {
            double radius = 1.0 + (pEntity.getRandom().nextDouble() - 0.5) * 0.5;
            double offsetX = radius * Math.cos(0.0);
            double offsetZ = radius * Math.sin(0.0);
            double x = pEntity.getX() + offsetX;
            double z = pEntity.getZ() + offsetZ;
            pEntity.level().addParticle((ParticleOptions)pType, x, y, z, pXSpeed, pYSpeed, pZSpeed);
        }
    }

    public static void generateCircleParticles(Entity pEntity, int pParticleCount, SimpleParticleType pType, boolean isCustomYNeeded, boolean isEyeHeight, double pXSpeed, double pYSpeed, double pZSpeed, double radius, double rotationSpeed) {
        double centerX = pEntity.getX();
        double centerY = isCustomYNeeded ? (isEyeHeight ? pEntity.getEyeY() : pEntity.getY()) : pEntity.getY() - 0.1;
        double centerZ = pEntity.getZ();
        rotationAngle += rotationSpeed;
        for (int i = 0; i < pParticleCount; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)pParticleCount + rotationAngle;
            double xOffset = Math.cos(angle) * radius;
            double zOffset = Math.sin(angle) * radius;
            double particleX = centerX + xOffset;
            double particleZ = centerZ + zOffset;
            pEntity.level().addParticle((ParticleOptions)pType, particleX, centerY, particleZ, pXSpeed, pYSpeed, pZSpeed);
        }
    }

    public static void generateCorruptionExplosionParticles(LivingEntity pEntity) {
        for (int i = 0; i < 100; ++i) {
            double offsetX = (pEntity.getRandom().nextDouble() - 0.5) * 2.0;
            double offsetY = pEntity.getRandom().nextDouble();
            double offsetZ = (pEntity.getRandom().nextDouble() - 0.5) * 2.0;
            double x = pEntity.getX();
            double y = pEntity.getY();
            double z = pEntity.getZ();
            pEntity.level().addParticle((ParticleOptions)ParticleTypes.SOUL, x + offsetX, y + offsetY, z + offsetZ, 0.0, 0.0, 0.0);
        }
    }

    public static void generatePetrifiedParticles(LivingEntity pEntity) {
        for (int i = 0; i < 20; ++i) {
            double offsetX = pEntity.getRandom().nextDouble() - 0.5;
            double offsetY = pEntity.getRandom().nextDouble() - 0.25;
            double offsetZ = pEntity.getRandom().nextDouble() - 0.5;
            double x = pEntity.getX();
            double y = pEntity.getEyeY();
            double z = pEntity.getZ();
            pEntity.level().addParticle((ParticleOptions)ParticleTypes.ASH, x + offsetX, y + offsetY, z + offsetZ, 0.0, 0.0, 0.0);
        }
    }

    public static void generateShockwaveParticles(Level pLevel, LivingEntity pEntity, double pRadius) {
        BlockState block = pLevel.getBlockState(pEntity.blockPosition().below());
        for (int i = 0; i < 100; ++i) {
            float angle = (float)(Math.PI * 2 * (double)i / 100.0);
            double x = pEntity.getX() + pRadius * (double)Mth.sin((float)angle);
            double y = pEntity.getY() + 0.2;
            double z = pEntity.getZ() + pRadius * (double)Mth.cos((float)angle);
            double ySpeed = pLevel.getRandom().nextGaussian() * 0.2;
            pLevel.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, block), x, y, z, 0.0, ySpeed, 0.0);
        }
    }

    public static void generateUmbralDoomOrbTrail(Level pLevel, int growTimer, Entity pEntity) {
        int particleCount = 15;
        double centerX = pEntity.getX() + pEntity.getRandom().nextDouble() - 0.5;
        double centerY = pEntity.getY() + pEntity.getRandom().nextDouble() - 0.5;
        double centerZ = pEntity.getZ() + pEntity.getRandom().nextDouble() - 0.5;
        for (int i = 0; i < particleCount; ++i) {
            pLevel.addParticle((ParticleOptions)MLParticles.SKULL_PARTICLES.get(), centerX, centerY, centerZ, 0.0, 0.0, 0.0);
        }
    }

    public static void generateSkullParticles(Entity pEntity) {
        double y = pEntity.getY() + 0.2;
        for (int i = 0; i < 3; ++i) {
            double x = pEntity.getX() + (pEntity.getRandom().nextDouble() - 0.5) * 2.0;
            double z = pEntity.getZ() + (pEntity.getRandom().nextDouble() - 0.5) * 2.0;
            pEntity.level().addParticle((ParticleOptions)MLParticles.SKULL_PARTICLES.get(), x, y, z, 0.0, 1.0, 0.0);
        }
    }

    public static void generateAltarOfTheDeadParticles(Level pLevel, BlockPos pPos) {
        double centerX = (double)pPos.getX() + 0.5;
        double centerY = (double)pPos.getY() + 0.25;
        double centerZ = (double)pPos.getZ() + 0.5;
        double rotationSpeed = 2.0;
        double radius = 1.0;
        int particleCount = 5;
        rotationAngle += rotationSpeed;
        for (int i = 0; i < particleCount; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)particleCount + rotationAngle;
            double xOffset = Math.cos(angle) * radius;
            double zOffset = Math.sin(angle) * radius;
            double particleX = centerX + xOffset;
            double particleZ = centerZ + zOffset;
            pLevel.addParticle((ParticleOptions)MLParticles.SKULL_PARTICLES.get(), particleX, centerY, particleZ, 0.0, 1.0, 0.0);
        }
    }
}

