/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.ovinter.mythsandlegends.client.model.entity.ImpModel;
import com.ovinter.mythsandlegends.entity.ImpEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.BlockAndItemGeoLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class ImpRenderer
extends GeoEntityRenderer<ImpEntity> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)"textures/entity/imp.png");

    public ImpRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new ImpModel());
        this.shadowRadius = 0.3f;
        this.addRenderLayer((GeoRenderLayer)new BlockAndItemGeoLayer<ImpEntity>(this, (GeoRenderer)this){

            @Nullable
            protected ItemStack getStackForBone(GeoBone bone, ImpEntity animatable) {
                return switch (bone.getName()) {
                    case "right_hand" -> animatable.getMainHandItem();
                    default -> null;
                };
            }

            protected ItemDisplayContext getTransformTypeForStack(GeoBone bone, ItemStack stack, ImpEntity animatable) {
                return switch (bone.getName()) {
                    case "right_hand" -> ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
                    default -> ItemDisplayContext.NONE;
                };
            }

            protected void renderStackForBone(PoseStack poseStack, GeoBone bone, ItemStack stack, ImpEntity animatable, MultiBufferSource bufferSource, float partialTick, int packedLight, int packedOverlay) {
                if (stack == animatable.getMainHandItem()) {
                    poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                    poseStack.scale(0.5f, 0.5f, 0.5f);
                    poseStack.translate(0.0, 0.0, 0.0);
                }
                super.renderStackForBone(poseStack, bone, stack, (GeoAnimatable)animatable, bufferSource, partialTick, packedLight, packedOverlay);
            }
        });
    }

    protected int getBlockLightLevel(ImpEntity pEntity, BlockPos pPos) {
        return 15;
    }

    public ResourceLocation getTextureLocation(ImpEntity pEntity) {
        return TEXTURE;
    }

    @Nullable
    public RenderType getRenderType(ImpEntity animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        return RenderType.entityTranslucent((ResourceLocation)TEXTURE);
    }
}

