/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.ovinter.mythsandlegends.client.model.entity.PossessedArmorModel;
import com.ovinter.mythsandlegends.entity.PossessedArmorEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.AutoGlowingGeoLayer;
import software.bernie.geckolib.renderer.layer.BlockAndItemGeoLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class PossessedArmorRenderer
extends GeoEntityRenderer<PossessedArmorEntity> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)"textures/entity/possessed_armor/possessed_armor.png");
    private static final ResourceLocation TEXTURE_DAMAGED = ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)"textures/entity/possessed_armor/possessed_armor_damaged.png");

    public PossessedArmorRenderer(EntityRendererProvider.Context context) {
        super(context, (GeoModel)new PossessedArmorModel());
        this.shadowRadius = 0.5f;
        this.addRenderLayer((GeoRenderLayer)new BlockAndItemGeoLayer<PossessedArmorEntity>(this, (GeoRenderer)this){

            @Nullable
            protected ItemStack getStackForBone(GeoBone bone, PossessedArmorEntity animatable) {
                return switch (bone.getName()) {
                    case "right_hand" -> animatable.getMainHandItem();
                    default -> null;
                };
            }

            protected ItemDisplayContext getTransformTypeForStack(GeoBone bone, ItemStack stack, PossessedArmorEntity animatable) {
                return switch (bone.getName()) {
                    case "right_hand" -> ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
                    default -> ItemDisplayContext.NONE;
                };
            }

            protected void renderStackForBone(PoseStack poseStack, GeoBone bone, ItemStack stack, PossessedArmorEntity animatable, MultiBufferSource bufferSource, float partialTick, int packedLight, int packedOverlay) {
                if (stack == animatable.getMainHandItem()) {
                    poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                    poseStack.translate(0.0, -0.5, 0.0);
                }
                super.renderStackForBone(poseStack, bone, stack, (GeoAnimatable)animatable, bufferSource, partialTick, packedLight, packedOverlay);
            }
        });
        this.addRenderLayer((GeoRenderLayer)new AutoGlowingGeoLayer((GeoRenderer)this));
    }

    public ResourceLocation getTextureLocation(PossessedArmorEntity animatable) {
        return animatable.getHasHalfHealth() ? TEXTURE_DAMAGED : TEXTURE;
    }

    @Nullable
    public RenderType getRenderType(PossessedArmorEntity animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        return RenderType.entityTranslucent((ResourceLocation)texture);
    }
}

