/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.effect;

import com.ovinter.mythsandlegends.api.util.ParticleGenerator;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class PetrifiedEffect
extends MobEffect {
    public PetrifiedEffect(MobEffectCategory pCategory, int pColor) {
        super(pCategory, pColor);
    }

    public boolean applyEffectTick(LivingEntity pLivingEntity, int pAmplifier) {
        ParticleGenerator.generatePetrifiedParticles(pLivingEntity);
        pLivingEntity.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.0);
        pLivingEntity.getAttribute(Attributes.JUMP_STRENGTH).setBaseValue(0.0);
        return super.applyEffectTick(pLivingEntity, pAmplifier);
    }

    public void removeAttributeModifiers(AttributeMap pAttributeMap) {
        super.removeAttributeModifiers(pAttributeMap);
        AttributeInstance movementSpeed = pAttributeMap.getInstance(Attributes.MOVEMENT_SPEED);
        AttributeInstance jumpStrength = pAttributeMap.getInstance(Attributes.JUMP_STRENGTH);
        if (movementSpeed != null && jumpStrength != null) {
            movementSpeed.setBaseValue(0.1);
            jumpStrength.setBaseValue(0.4);
        }
    }

    public boolean shouldApplyEffectTickThisTick(int pDuration, int pAmplifier) {
        return true;
    }
}

