/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity;

import com.ovinter.mythsandlegends.api.util.ParticleGenerator;
import com.ovinter.mythsandlegends.api.util.SendMessageToPlayer;
import com.ovinter.mythsandlegends.entity.goal.black_charro.ShootUmbralOrbGoal;
import com.ovinter.mythsandlegends.entity.goal.black_charro.SummonMinionsGoal;
import com.ovinter.mythsandlegends.entity.goal.black_charro.TeleportGoal;
import com.ovinter.mythsandlegends.registry.MLParticles;
import com.ovinter.mythsandlegends.registry.MLSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BlackCharroEntity
extends Monster
implements Enemy,
GeoEntity {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation IDLE = RawAnimation.begin().thenPlay("IDLE");
    private static final RawAnimation WALK = RawAnimation.begin().thenPlay("WALK");
    private static final RawAnimation SHOOT = RawAnimation.begin().thenPlay("SHOOT");
    private static final RawAnimation SUMMON_SKELETONS = RawAnimation.begin().thenPlay("SUMMON");
    private static final RawAnimation RAGE = RawAnimation.begin().thenPlay("RAGE");
    private static final RawAnimation ATTACK = RawAnimation.begin().thenPlay("ATTACK");
    public static final RawAnimation SPAWN = RawAnimation.begin().thenPlay("SPAWN");
    public static final RawAnimation DEATH = RawAnimation.begin().thenPlay("DEATH");
    private static final EntityDataAccessor<Integer> TELEPORT_CHANCE = SynchedEntityData.defineId(BlackCharroEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> REGENERATION = SynchedEntityData.defineId(BlackCharroEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> INVULNERABILITY = SynchedEntityData.defineId(BlackCharroEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private final ServerBossEvent bossEvent = (ServerBossEvent)new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS).setDarkenScreen(true);
    public float healthPercentage;
    private int lightingCooldown = 60;
    private int combatMessageCooldown = 300;

    public BlackCharroEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.xpReward = 50;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 500.0).add(Attributes.ARMOR, 10.0).add(Attributes.KNOCKBACK_RESISTANCE, (double)0.6f).add(Attributes.MOVEMENT_SPEED, 0.35).add(Attributes.WATER_MOVEMENT_EFFICIENCY, 0.5).add(Attributes.FOLLOW_RANGE, 30.0).add(Attributes.ATTACK_DAMAGE, 9.0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(3, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new TeleportGoal(this));
        this.goalSelector.addGoal(3, (Goal)new ShootUmbralOrbGoal(this));
        this.goalSelector.addGoal(3, (Goal)new SummonMinionsGoal(this));
        this.goalSelector.addGoal(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 25.0f));
        this.goalSelector.addGoal(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(TELEPORT_CHANCE, (Object)9);
        pBuilder.define(REGENERATION, (Object)2);
        pBuilder.define(INVULNERABILITY, (Object)40);
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putInt("Regeneration", ((Integer)this.entityData.get(REGENERATION)).intValue());
        pCompound.putInt("Teleport", ((Integer)this.entityData.get(TELEPORT_CHANCE)).intValue());
        pCompound.putInt("Invulnerability", ((Integer)this.entityData.get(INVULNERABILITY)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.getEntityData().set(REGENERATION, (Object)pCompound.getInt("Regeneration"));
        this.getEntityData().set(TELEPORT_CHANCE, (Object)pCompound.getInt("Teleport"));
        this.getEntityData().set(INVULNERABILITY, (Object)pCompound.getInt("Invulnerability"));
    }

    public void setCustomName(@Nullable Component pName) {
        super.setCustomName(pName);
        this.bossEvent.setName(this.getDisplayName());
    }

    public void tick() {
        this.healthPercentage = this.getHealth() / this.getMaxHealth();
        this.handleMessageCooldown();
        this.handleRageMode();
        this.handleSummonLightingCooldown();
        if (!this.isDeadOrDying()) {
            ParticleGenerator.generateSkullParticles((Entity)this);
        }
        super.tick();
    }

    protected void customServerAiStep() {
        this.bossEvent.setProgress(this.healthPercentage);
        if (this.getInvulnerabilityTimer() > 0) {
            this.setInvulnerabilityTimer(this.getInvulnerabilityTimer() - 1);
        }
        super.customServerAiStep();
    }

    public void startSeenByPlayer(ServerPlayer pServerPlayer) {
        super.startSeenByPlayer(pServerPlayer);
        this.bossEvent.addPlayer(pServerPlayer);
    }

    public void stopSeenByPlayer(ServerPlayer pServerPlayer) {
        super.stopSeenByPlayer(pServerPlayer);
        this.bossEvent.removePlayer(pServerPlayer);
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        if (this.isDeadOrDying() || this.getInvulnerabilityTimer() > 40 || pSource.is(DamageTypeTags.IS_FIRE) || pSource.is(DamageTypeTags.IS_DROWNING) || pSource.is(DamageTypeTags.IS_FALL) || pSource.is(DamageTypeTags.WITHER_IMMUNE_TO) || pSource.is(DamageTypeTags.WITHER_IMMUNE_TO)) {
            return false;
        }
        return super.hurt(pSource, pAmount);
    }

    protected SoundEvent getHurtSound(DamageSource pDamageSource) {
        return MLSounds.BLACK_CHARRO_HURT.get();
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return !this.isDeadOrDying() ? MLSounds.BLACK_CHARRO_AMBIENT.get() : null;
    }

    protected SoundEvent getDeathSound() {
        return MLSounds.BLACK_CHARRO_DEATH.get();
    }

    protected void playStepSound(BlockPos pPos, BlockState pState) {
    }

    public boolean removeWhenFarAway(double pDistanceToClosestPlayer) {
        return false;
    }

    public boolean canChangeDimensions(Level pOldLevel, Level pNewLevel) {
        return false;
    }

    public boolean isOnFire() {
        return false;
    }

    public void die(DamageSource pDamageSource) {
        super.die(pDamageSource);
        LivingEntity target = this.getTarget();
        if (target != null && this.getTarget().hasEffect(MobEffects.BLINDNESS)) {
            SendMessageToPlayer.sendRandomMessage("gets_defeated", (Player)target);
            this.getTarget().removeEffect(MobEffects.BLINDNESS);
        }
    }

    protected void tickDeath() {
        ++this.deathTime;
        if (this.deathTime == 50 && !this.level().isClientSide()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)60);
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    public void setInvulnerabilityTimer(int ticks) {
        this.getEntityData().set(INVULNERABILITY, (Object)ticks);
    }

    public int getInvulnerabilityTimer() {
        return (Integer)this.getEntityData().get(INVULNERABILITY);
    }

    public int getTeleportChance() {
        return (Integer)this.getEntityData().get(TELEPORT_CHANCE);
    }

    PlayState predicate(AnimationState<?> state) {
        return state.isMoving() ? state.setAndContinue(WALK) : state.setAndContinue(IDLE);
    }

    protected PlayState attackPredicate(AnimationState<?> state) {
        if (this.swinging && state.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            state.getController().forceAnimationReset();
            this.swinging = false;
            return state.setAndContinue(ATTACK);
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate).triggerableAnim("spawn", SPAWN).triggerableAnim("walk", WALK).triggerableAnim("idle", IDLE).triggerableAnim("summon", SUMMON_SKELETONS).triggerableAnim("rage", RAGE));
        controllers.add(new AnimationController((GeoAnimatable)this, "deathController", 0, state -> {
            if (this.isDeadOrDying() || (double)this.getHealth() < 0.01) {
                state.getController().setAnimation(DEATH);
            }
            return PlayState.CONTINUE;
        }));
        controllers.add(new AnimationController((GeoAnimatable)this, "attackController", 2, this::attackPredicate).triggerableAnim("shoot", SHOOT));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    public void handleMessageCooldown() {
        LivingEntity livingEntity;
        if (this.combatMessageCooldown >= 0) {
            --this.combatMessageCooldown;
        } else if (!this.isDeadOrDying() && (livingEntity = this.getTarget()) instanceof Player) {
            Player player = (Player)livingEntity;
            this.playAmbientSound();
            SendMessageToPlayer.sendRandomMessage("combat_message", player);
            this.combatMessageCooldown = 300;
        }
    }

    public void handleRageMode() {
        if ((double)this.healthPercentage > 0.3 && (double)this.healthPercentage <= 0.6 && (Integer)this.getEntityData().get(REGENERATION) > 0 && !this.hasEffect(MobEffects.LEVITATION)) {
            this.rage();
        }
    }

    public void handleSummonLightingCooldown() {
        if ((double)this.healthPercentage <= 0.3 && this.lightingCooldown <= 0 && !this.isDeadOrDying()) {
            this.summonLightingInRadius();
        } else {
            --this.lightingCooldown;
        }
    }

    public void rage() {
        this.triggerAnim("controller", "rage");
        this.getEntityData().set(REGENERATION, (Object)((Integer)this.getEntityData().get(REGENERATION) - 1));
        this.getEntityData().set(TELEPORT_CHANCE, (Object)((Integer)this.getEntityData().get(TELEPORT_CHANCE) + 3));
        this.teleportAndBlindTarget();
        this.addEffect(new MobEffectInstance(MobEffects.LEVITATION, 200, 0, false, false));
        this.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 200, 8, false, false));
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos pos = new BlockPos((int)this.getX(), (int)this.getY(), (int)this.getZ());
            serverLevel.playSound(null, pos, MLSounds.BLACK_CHARRO_RAGE.get(), SoundSource.HOSTILE, 4.0f, 1.0f);
            LightningBolt lightningBolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create((Level)serverLevel);
            if (lightningBolt != null) {
                lightningBolt.moveTo(Vec3.atBottomCenterOf((Vec3i)pos));
                lightningBolt.setVisualOnly(true);
                serverLevel.addFreshEntity((Entity)lightningBolt);
            }
        }
    }

    public void summonLightingInRadius() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 200, 1, false, false));
            if (this.getTarget() != null) {
                this.getTarget().addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 9999, 0, false, false));
            }
            for (int i = 0; i < 5; ++i) {
                double offsetX = (this.random.nextDouble() - 0.5) * 2.0 * 20.0;
                double offsetZ = (this.random.nextDouble() - 0.5) * 2.0 * 20.0;
                double x = this.getX() + offsetX;
                double y = this.getY();
                double z = this.getZ() + offsetZ;
                BlockPos targetPos = new BlockPos((int)x, (int)y, (int)z);
                LightningBolt lightningBolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create((Level)serverLevel);
                if (lightningBolt != null) {
                    lightningBolt.moveTo(Vec3.atBottomCenterOf((Vec3i)targetPos));
                    serverLevel.addFreshEntity((Entity)lightningBolt);
                }
                this.lightingCooldown = 60;
            }
        }
    }

    public void teleportAndBlindTarget() {
        double targetZ;
        double targetY;
        double targetX;
        if (this.getTarget() != null && this.isValidTeleportLocation(targetX = this.getTarget().getX() + (this.getTarget().getRandom().nextDouble() - 0.5) * 15.0, targetY = this.getTarget().getY(), targetZ = this.getTarget().getZ() + (this.getTarget().getRandom().nextDouble() - 0.5) * 15.0)) {
            this.getTarget().addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 60, 0, false, true));
            this.getTarget().teleportTo(targetX, targetY, targetZ);
            this.level().addParticle((ParticleOptions)MLParticles.SKULL_PARTICLES.get(), 1.0, 1.0, 0.0, 0.0, 0.0, 0.0);
            this.playSound(MLSounds.BLACK_CHARRO_TELEPORT.get(), 1.0f, 1.0f);
        }
    }

    public boolean isValidTeleportLocation(double x, double y, double z) {
        BlockPos pos = new BlockPos((int)x, (int)y, (int)z);
        return this.level().getBlockState(pos).isAir() && this.level().getBlockState(pos.below()).isSolid();
    }
}

