/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity;

import com.ovinter.mythsandlegends.api.util.ParticleGenerator;
import com.ovinter.mythsandlegends.entity.goal.gargoyle.ConditionalLookAtPlayerGoal;
import com.ovinter.mythsandlegends.entity.goal.gargoyle.ConditionalMeleeAttackGoal;
import com.ovinter.mythsandlegends.entity.goal.gargoyle.ConditionalNearestAttackableTargetGoal;
import com.ovinter.mythsandlegends.entity.goal.gargoyle.ConditionalRandomLookAroundGoal;
import com.ovinter.mythsandlegends.entity.goal.gargoyle.ShockwaveAttackGoal;
import com.ovinter.mythsandlegends.registry.MLEffects;
import com.ovinter.mythsandlegends.registry.MLSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GargoyleEntity
extends Monster
implements GeoEntity {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("IDLE");
    private static final RawAnimation IDLE_AWAKE = RawAnimation.begin().thenLoop("IDLE_AWAKE");
    private static final RawAnimation WALK = RawAnimation.begin().thenLoop("WALK");
    private static final RawAnimation ATTACK = RawAnimation.begin().thenPlay("ATTACK");
    private static final RawAnimation SHOCKWAVE_ATTACK = RawAnimation.begin().thenPlay("SHOCKWAVE_ATTACK");
    private static final EntityDataAccessor<Boolean> AWAKE = SynchedEntityData.defineId(GargoyleEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final double petrifiedChance = 0.2;
    public boolean isAwake;

    public GargoyleEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.xpReward = 15;
        this.isAwake = false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 120.0).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.FOLLOW_RANGE, 30.0).add(Attributes.ATTACK_DAMAGE, 12.0).add(Attributes.ATTACK_KNOCKBACK, (double)1.2f).add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(4, (Goal)new ShockwaveAttackGoal(this));
        this.goalSelector.addGoal(5, (Goal)new ConditionalMeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(6, (Goal)new ConditionalLookAtPlayerGoal((Mob)this, Player.class, 12.0f));
        this.goalSelector.addGoal(7, (Goal)new ConditionalRandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, new ConditionalNearestAttackableTargetGoal<Player>((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, new ConditionalNearestAttackableTargetGoal<IronGolem>((Mob)this, IronGolem.class, true));
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(AWAKE, (Object)false);
    }

    public void tick() {
        super.tick();
        this.setAwake(!this.level().isDay());
    }

    public void setAwake(boolean pAwake) {
        if (this.isAwake != pAwake) {
            this.entityData.set(AWAKE, (Object)pAwake);
            this.isAwake = pAwake;
        }
    }

    public boolean getAwake() {
        return (Boolean)this.entityData.get(AWAKE);
    }

    public boolean isPushable() {
        return false;
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        if (pSource.is(DamageTypes.GENERIC_KILL)) {
            return super.hurt(pSource, pAmount);
        }
        if (!this.isAwake) {
            return false;
        }
        if (pSource.is(DamageTypeTags.IS_PROJECTILE) || pSource.is(DamageTypeTags.IS_FIRE) || pSource.is(DamageTypeTags.IS_FREEZING) || pSource.is(DamageTypeTags.IS_DROWNING)) {
            return false;
        }
        return super.hurt(pSource, pAmount);
    }

    public boolean doHurtTarget(Entity pEntity) {
        boolean success = super.doHurtTarget(pEntity);
        if (success && pEntity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)pEntity;
            if (this.level().random.nextDouble() < 0.2) {
                this.performPetrifiedEffect(target);
            }
            this.playAttackSound();
        }
        return success;
    }

    private void performPetrifiedEffect(LivingEntity target) {
        target.addEffect(new MobEffectInstance(MLEffects.PETRIFIED, 40, 0));
        this.playSound(SoundEvents.ZOMBIE_VILLAGER_CURE, 1.0f, 1.0f);
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    public boolean isAffectedByPotions() {
        return false;
    }

    public void handleEntityEvent(byte pId) {
        if (pId == 69 && !this.isDeadOrDying()) {
            ParticleGenerator.generateShockwaveParticles(this.level(), (LivingEntity)this, 4.0);
        } else {
            super.handleEntityEvent(pId);
        }
    }

    protected SoundEvent getHurtSound(DamageSource pDamageSource) {
        return MLSounds.GARGOYLE_HURT.get();
    }

    protected void playAttackSound() {
        this.playSound(MLSounds.GARGOYLE_ATTACK.get(), 1.0f, 1.0f);
    }

    protected void playStepSound(BlockPos pPos, BlockState pState) {
        super.playStepSound(pPos, pState);
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        if (!this.getAwake()) {
            return null;
        }
        return MLSounds.GARGOYLE_AMBIENT.get();
    }

    protected SoundEvent getDeathSound() {
        return MLSounds.GARGOYLE_DEATH.get();
    }

    public boolean isOnFire() {
        return false;
    }

    private PlayState movementPredicate(AnimationState<?> state) {
        if (!this.getAwake()) {
            return state.setAndContinue(IDLE);
        }
        if (state.isMoving() && this.getAwake()) {
            return state.setAndContinue(WALK);
        }
        return state.setAndContinue(IDLE_AWAKE);
    }

    private PlayState attackPredicate(AnimationState<?> state) {
        if (this.swinging && this.getAwake() && state.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            state.getController().forceAnimationReset();
            this.swinging = false;
            return state.setAndContinue(ATTACK);
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "movementController", 5, this::movementPredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "attackController", 5, this::attackPredicate).triggerableAnim("shockwave", SHOCKWAVE_ATTACK));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }
}

