/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity;

import com.ovinter.mythsandlegends.api.util.ParticleGenerator;
import com.ovinter.mythsandlegends.entity.ImpCloneEntity;
import com.ovinter.mythsandlegends.entity.goal.imp.AttackGoal;
import com.ovinter.mythsandlegends.entity.goal.imp.FireballAttackGoal;
import com.ovinter.mythsandlegends.registry.MLEntities;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ImpEntity
extends Monster
implements GeoEntity {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("IDLE");
    private static final RawAnimation WALK = RawAnimation.begin().thenLoop("WALK");
    private static final RawAnimation ATTACK = RawAnimation.begin().then("ATTACK", Animation.LoopType.PLAY_ONCE);
    private static final RawAnimation CHARGE_ATTACK = RawAnimation.begin().then("CHARGE_ATTACK", Animation.LoopType.PLAY_ONCE);
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.defineId(ImpEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_SHOOTING = SynchedEntityData.defineId(ImpEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> CLONE = SynchedEntityData.defineId(ImpEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    @Nullable
    private BlockPos boundOrigin;
    public String animationProcedure;

    public ImpEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.moveControl = new ImpMoveControl(this);
        this.xpReward = 4;
        this.animationProcedure = "empty";
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 14.0).add(Attributes.FOLLOW_RANGE, 30.0).add(Attributes.FLYING_SPEED, 0.6).add(Attributes.ATTACK_DAMAGE, 6.0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new FireballAttackGoal(this));
        this.goalSelector.addGoal(4, (Goal)new AttackGoal(this));
        this.goalSelector.addGoal(4, (Goal)new ImpRandomMoveGoal());
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(ATTACKING, (Object)false);
        pBuilder.define(CLONE, (Object)false);
        pBuilder.define(IS_SHOOTING, (Object)false);
    }

    public void tick() {
        this.noPhysics = true;
        super.tick();
        this.noPhysics = false;
        this.setNoGravity(true);
        if (this.level().isClientSide()) {
            ParticleGenerator.generateCircleParticles((Entity)this, 5, ParticleTypes.SMALL_FLAME, false, false, 0.0, 0.0, 0.0, 0.2, 1.0);
        }
    }

    public void move(MoverType pType, Vec3 pPos) {
        super.move(pType, pPos);
        this.checkInsideBlocks();
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        if (this.isDeadOrDying() || pSource.is(DamageTypeTags.IS_FIRE) || pSource.is(DamageTypeTags.WITHER_IMMUNE_TO)) {
            return false;
        }
        return super.hurt(pSource, pAmount);
    }

    public void die(DamageSource pDamageSource) {
        if (!this.isClone()) {
            for (int i = 0; i < 2; ++i) {
                ImpCloneEntity clone = (ImpCloneEntity)MLEntities.IMP_CLONE.get().create(this.level());
                if (clone == null) continue;
                clone.setPos(this.getX() + 2.0, this.getY(), this.getZ());
                for (int j = 0; j < 20; ++j) {
                    this.level().addParticle((ParticleOptions)ParticleTypes.POOF, clone.getX(), clone.getY(), clone.getZ(), 0.0, 0.0, 0.0);
                }
                clone.setClone(true);
                this.level().addFreshEntity((Entity)clone);
            }
        }
        super.die(pDamageSource);
    }

    public boolean isClone() {
        return (Boolean)this.entityData.get(CLONE);
    }

    public boolean isAttacking() {
        return (Boolean)this.entityData.get(ATTACKING);
    }

    public boolean isShooting() {
        return (Boolean)this.entityData.get(IS_SHOOTING);
    }

    public void setClone(boolean pClone) {
        this.entityData.set(CLONE, (Object)pClone);
    }

    public void setAttacking(boolean pAttacking) {
        this.entityData.set(ATTACKING, (Object)pAttacking);
    }

    public void setShooting(boolean pShooting) {
        this.entityData.set(IS_SHOOTING, (Object)pShooting);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pSpawnType, @javax.annotation.Nullable SpawnGroupData pSpawnGroupData) {
        RandomSource randomsource = pLevel.getRandom();
        this.populateDefaultEquipmentSlots(randomsource, pDifficulty);
        this.populateDefaultEquipmentEnchantments(pLevel, randomsource, pDifficulty);
        return super.finalizeSpawn(pLevel, pDifficulty, pSpawnType, pSpawnGroupData);
    }

    protected void populateDefaultEquipmentSlots(RandomSource pRandom, DifficultyInstance pDifficulty) {
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.TRIDENT));
        this.setDropChance(EquipmentSlot.MAINHAND, 0.0f);
    }

    protected SoundEvent getAmbientSound() {
        this.playSound(SoundEvents.PARROT_IMITATE_VEX, 1.0f, 0.5f);
        return null;
    }

    protected SoundEvent getDeathSound() {
        this.playSound(SoundEvents.VEX_DEATH, 1.0f, 0.5f);
        return null;
    }

    protected SoundEvent getHurtSound(DamageSource pDamageSource) {
        this.playSound(SoundEvents.VEX_HURT, 1.0f, 0.5f);
        return null;
    }

    @Nullable
    public BlockPos getBoundOrigin() {
        return this.boundOrigin;
    }

    private PlayState movementPredicate(AnimationState<?> state) {
        if (!this.animationProcedure.equals("empty")) {
            return PlayState.STOP;
        }
        if (state.isMoving() && !this.isShooting() && !this.isAttacking()) {
            return state.setAndContinue(WALK);
        }
        return state.setAndContinue(IDLE);
    }

    private PlayState attackPredicate(AnimationState<?> state) {
        if (state.isMoving() && this.isAttacking() && !this.isShooting() && state.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            state.getController().forceAnimationReset();
            state.getController().setAnimation(ATTACK);
        }
        return PlayState.CONTINUE;
    }

    private PlayState chargeAttackPredicate(AnimationState<?> state) {
        if (state.isMoving() && this.isShooting() && !this.isAttacking() && state.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            state.getController().forceAnimationReset();
            state.getController().setAnimation(CHARGE_ATTACK);
        }
        return PlayState.CONTINUE;
    }

    private PlayState procedurePredicate(AnimationState<?> state) {
        if (!this.animationProcedure.equals("empty") && state.getController().getAnimationState() == AnimationController.State.STOPPED) {
            state.getController().setAnimation(RawAnimation.begin().thenPlay(this.animationProcedure));
            if (state.getController().getAnimationState() == AnimationController.State.STOPPED) {
                this.animationProcedure = "empty";
                state.getController().forceAnimationReset();
            }
        } else if (this.animationProcedure.equals("empty")) {
            return PlayState.STOP;
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "movementController", 5, this::movementPredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "attackController", 5, this::attackPredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "chargeAttackController", 5, this::chargeAttackPredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "predicateController", 0, this::procedurePredicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    class ImpMoveControl
    extends MoveControl {
        public ImpMoveControl(ImpEntity pImp) {
            super((Mob)pImp);
        }

        public void tick() {
            if (this.operation == MoveControl.Operation.MOVE_TO) {
                Vec3 vec3 = new Vec3(this.wantedX - ImpEntity.this.getX(), this.wantedY - ImpEntity.this.getY(), this.wantedZ - ImpEntity.this.getZ());
                double d0 = vec3.length();
                if (d0 < ImpEntity.this.getBoundingBox().getSize()) {
                    this.operation = MoveControl.Operation.WAIT;
                    ImpEntity.this.setDeltaMovement(ImpEntity.this.getDeltaMovement().scale(0.5));
                } else {
                    ImpEntity.this.setDeltaMovement(ImpEntity.this.getDeltaMovement().add(vec3.scale(this.speedModifier * 0.05 / d0)));
                    if (ImpEntity.this.getTarget() == null) {
                        Vec3 vec31 = ImpEntity.this.getDeltaMovement();
                        ImpEntity.this.setYRot(-((float)Mth.atan2((double)vec31.x, (double)vec31.z)) * 57.295776f);
                        ImpEntity.this.yBodyRot = ImpEntity.this.getYRot();
                    } else {
                        double d2 = ImpEntity.this.getTarget().getX() - ImpEntity.this.getX();
                        double d1 = ImpEntity.this.getTarget().getZ() - ImpEntity.this.getZ();
                        ImpEntity.this.setYRot(-((float)Mth.atan2((double)d2, (double)d1)) * 57.295776f);
                        ImpEntity.this.yBodyRot = ImpEntity.this.getYRot();
                    }
                }
            }
        }
    }

    public class ImpRandomMoveGoal
    extends Goal {
        public ImpRandomMoveGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            return !ImpEntity.this.getMoveControl().hasWanted() && ImpEntity.this.random.nextInt(ImpRandomMoveGoal.reducedTickDelay((int)7)) == 0;
        }

        public void tick() {
            BlockPos blockPos = ImpEntity.this.getBoundOrigin();
            if (blockPos == null) {
                blockPos = ImpEntity.this.blockPosition();
            }
            for (int i = 0; i < 3; ++i) {
                BlockPos blockPos1 = blockPos.offset(ImpEntity.this.random.nextInt(15) - 7, ImpEntity.this.random.nextInt(11) - 5, ImpEntity.this.random.nextInt(15) - 7);
                if (!ImpEntity.this.level().isEmptyBlock(blockPos1)) continue;
                ImpEntity.this.moveControl.setWantedPosition((double)blockPos1.getX() + 0.5, (double)blockPos1.getY() + 0.5, (double)blockPos1.getZ() + 0.5, 0.25);
                if (ImpEntity.this.getTarget() != null) break;
                ImpEntity.this.getLookControl().setLookAt((double)blockPos1.getX() + 0.5, (double)blockPos1.getY() + 0.5, (double)blockPos1.getZ() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }
}

