/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity;

import com.ovinter.mythsandlegends.api.util.ParticleGenerator;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PossessedArmorEntity
extends Monster
implements GeoEntity {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation IDLE = RawAnimation.begin().then("IDLE", Animation.LoopType.PLAY_ONCE);
    private static final RawAnimation WALK = RawAnimation.begin().thenLoop("WALK");
    private static final RawAnimation ATTACK = RawAnimation.begin().thenPlay("ATTACK");
    private static final RawAnimation DEATH = RawAnimation.begin().thenPlay("DEATH");
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.defineId(PossessedArmorEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> HAS_HALF_HEALTH = SynchedEntityData.defineId(PossessedArmorEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private boolean hasPlayedHalfHealthSound = false;
    public String animationProcedure;

    public PossessedArmorEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.xpReward = 12;
        this.animationProcedure = "empty";
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 100.0).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.WATER_MOVEMENT_EFFICIENCY, (double)0.2f).add(Attributes.FOLLOW_RANGE, 30.0).add(Attributes.ARMOR, 20.0).add(Attributes.ARMOR_TOUGHNESS, 10.0).add(Attributes.ATTACK_DAMAGE, 10.0).add(Attributes.ATTACK_KNOCKBACK, 1.0).add(Attributes.KNOCKBACK_RESISTANCE, (double)0.7f);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.1, true));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 12.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(ATTACKING, (Object)false);
        pBuilder.define(HAS_HALF_HEALTH, (Object)false);
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putFloat("Health", this.getHealth());
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        if (pCompound.contains("Health")) {
            this.setHealth(pCompound.getFloat("Health"));
        }
    }

    public void tick() {
        if (this.getHealth() <= this.getMaxHealth() / 2.0f && !this.hasPlayedHalfHealthSound) {
            this.setHasHalfHealth(true);
        }
        if (this.onGround() && this.level().isClientSide()) {
            ParticleGenerator.generateDustParticles((Entity)this, 0.0f, 0.0f, 0.0f, !this.getHasHalfHealth() ? 1.0f : 1.5f, false, false, 0.0, 1.0, 0.0);
        }
        super.tick();
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pSpawnType, @Nullable SpawnGroupData pSpawnGroupData) {
        RandomSource randomsource = pLevel.getRandom();
        this.populateDefaultEquipmentSlots(randomsource, pDifficulty);
        this.populateDefaultEquipmentEnchantments(pLevel, randomsource, pDifficulty);
        return super.finalizeSpawn(pLevel, pDifficulty, pSpawnType, pSpawnGroupData);
    }

    protected void populateDefaultEquipmentSlots(RandomSource pRandom, DifficultyInstance pDifficulty) {
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.NETHERITE_SWORD));
        this.setDropChance(EquipmentSlot.MAINHAND, 0.0f);
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        if (this.isDeadOrDying() || pSource.is(DamageTypeTags.IS_FIRE) || pSource.is(DamageTypeTags.IS_DROWNING)) {
            return false;
        }
        return super.hurt(pSource, pAmount);
    }

    protected void playStepSound(BlockPos pos, BlockState blockIn) {
        this.playSound(SoundEvents.NETHERITE_BLOCK_PLACE, 2.0f, 0.1f);
        super.playStepSound(pos, blockIn);
    }

    protected SoundEvent getHurtSound(DamageSource pDamageSource) {
        this.playSound((SoundEvent)SoundEvents.ARMOR_EQUIP_NETHERITE.value(), 10.0f, 0.3f);
        if (this.getHealth() <= this.getMaxHealth() / 2.0f && !this.hasPlayedHalfHealthSound) {
            this.playSound(SoundEvents.CHAIN_BREAK, 10.0f, 0.3f);
            this.hasPlayedHalfHealthSound = true;
        }
        return null;
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.CHAIN_BREAK;
    }

    protected SoundEvent getDeathSound() {
        this.playSound(SoundEvents.SCULK_SENSOR_BREAK, 10.0f, 0.3f);
        return null;
    }

    public void setHasHalfHealth(boolean hasHalfHealth) {
        this.entityData.set(HAS_HALF_HEALTH, (Object)hasHalfHealth);
    }

    public boolean getHasHalfHealth() {
        return (Boolean)this.entityData.get(HAS_HALF_HEALTH);
    }

    private PlayState movementPredicate(AnimationState<?> state) {
        if (!this.animationProcedure.equals("empty")) {
            return PlayState.STOP;
        }
        if (state.isMoving()) {
            return state.setAndContinue(WALK);
        }
        if (this.isDeadOrDying()) {
            return state.setAndContinue(DEATH);
        }
        return state.setAndContinue(IDLE);
    }

    private PlayState attackPredicate(AnimationState<?> state) {
        if (this.swinging && state.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            state.getController().forceAnimationReset();
            state.getController().setAnimation(ATTACK);
        }
        return PlayState.CONTINUE;
    }

    private PlayState procedurePredicate(AnimationState<?> state) {
        if (!this.animationProcedure.equals("empty") && state.getController().getAnimationState() == AnimationController.State.STOPPED) {
            state.getController().setAnimation(RawAnimation.begin().thenPlay(this.animationProcedure));
            if (state.getController().getAnimationState() == AnimationController.State.STOPPED) {
                this.animationProcedure = "empty";
                state.getController().forceAnimationReset();
            }
        } else if (this.animationProcedure.equals("empty")) {
            return PlayState.STOP;
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "movementController", 5, this::movementPredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "attackController", 5, this::attackPredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "procedureController", 0, this::procedurePredicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }
}

