/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity.goal.black_charro;

import com.ovinter.mythsandlegends.entity.BlackCharroEntity;
import com.ovinter.mythsandlegends.entity.projectile.UmbralOrbEntity;
import com.ovinter.mythsandlegends.registry.MLEntities;
import com.ovinter.mythsandlegends.registry.MLSounds;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public class ShootUmbralOrbGoal
extends Goal {
    BlackCharroEntity mob;
    LivingEntity target;
    private int SHOOT_COOLDOWN = 40;

    public ShootUmbralOrbGoal(BlackCharroEntity pEntity) {
        this.mob = pEntity;
    }

    public boolean canUse() {
        this.target = this.mob.getTarget();
        return this.target != null && this.target.isAlive() && this.mob.distanceTo((Entity)this.target) >= 4.0f;
    }

    public boolean canContinueToUse() {
        return this.SHOOT_COOLDOWN < 0;
    }

    public void stop() {
        this.target = null;
    }

    public void tick() {
        if (this.SHOOT_COOLDOWN > 0) {
            --this.SHOOT_COOLDOWN;
        } else {
            this.mob.getLookControl().setLookAt((Entity)this.target, 30.0f, 30.0f);
            this.mob.lookAt((Entity)this.target, 30.0f, 30.0f);
            double baseX = this.target.getX() - this.mob.getX();
            double baseY = this.target.getY() - this.mob.getY();
            double baseZ = this.target.getZ() - this.mob.getZ();
            if (this.mob.hasEffect(MobEffects.LEVITATION)) {
                this.shootUmbralOrb(baseX, baseY, baseZ, 0.0);
                this.shootUmbralOrb(baseX, baseY, baseZ, -20.0);
                this.shootUmbralOrb(baseX, baseY, baseZ, 20.0);
            } else {
                this.shootUmbralOrb(baseX, baseY, baseZ, 0.0);
            }
        }
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    private void shootUmbralOrb(double x, double y, double z, double angleOffset) {
        this.mob.playSound(MLSounds.UMBRAL_DOOM_ORB_SHOOT.get(), 1.0f, 1.0f);
        UmbralOrbEntity orb = new UmbralOrbEntity(MLEntities.UMBRAL_ORB.get(), this.mob.level(), (LivingEntity)this.mob);
        double radians = Math.toRadians(angleOffset);
        double rotatedX = x * Math.cos(radians) - z * Math.sin(radians);
        double rotatedZ = x * Math.sin(radians) + z * Math.cos(radians);
        orb.shoot(rotatedX, y, rotatedZ, 1.5f, 0.0f - (float)(this.mob.level().getDifficulty().getId() * 4));
        this.mob.level().addFreshEntity((Entity)orb);
        this.mob.triggerAnim("attackController", "shoot");
        this.SHOOT_COOLDOWN = this.mob.hasEffect(MobEffects.LEVITATION) ? 20 : 40;
    }
}

