/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity.goal.black_charro;

import com.ovinter.mythsandlegends.api.util.SendMessageToPlayer;
import com.ovinter.mythsandlegends.entity.BlackCharroEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.player.Player;

public class SummonMinionsGoal
extends Goal {
    BlackCharroEntity mob;
    LivingEntity target;
    private int SUMMON_COOLDOWN = 100;
    private int SKELETONS_TO_SPAWN = 3;

    public SummonMinionsGoal(BlackCharroEntity pEntity) {
        this.mob = pEntity;
    }

    public boolean canUse() {
        this.target = this.mob.getTarget();
        return this.target != null && this.target.isAlive() && this.mob.onGround() && !this.mob.isDeadOrDying();
    }

    public boolean canContinueToUse() {
        return this.SUMMON_COOLDOWN < 0;
    }

    public void stop() {
        this.target = null;
    }

    public void tick() {
        if (this.SUMMON_COOLDOWN > 0) {
            --this.SUMMON_COOLDOWN;
        } else {
            SendMessageToPlayer.sendRandomMessage("summon_skeleton", (Player)this.target);
            this.summonSkeletons();
        }
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    void summonSkeletons() {
        this.mob.triggerAnim("controller", "summon");
        this.SKELETONS_TO_SPAWN = (double)this.mob.healthPercentage <= 0.6 ? 6 : 3;
        for (int i = 0; i < this.SKELETONS_TO_SPAWN; ++i) {
            Skeleton skeleton = new Skeleton(EntityType.SKELETON, this.mob.level());
            double offsetX = (this.mob.getRandom().nextDouble() - 0.5) * 5.0;
            double offsetZ = (this.mob.getRandom().nextDouble() - 0.5) * 5.0;
            skeleton.setPos(this.mob.getX() + offsetX, this.mob.getY(), this.mob.getZ() + offsetZ);
            this.mob.level().addFreshEntity((Entity)skeleton);
        }
        this.SUMMON_COOLDOWN = (double)this.mob.healthPercentage <= 0.6 ? 240 : 440;
    }
}

