/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity.goal.gargoyle;

import com.ovinter.mythsandlegends.entity.GargoyleEntity;
import com.ovinter.mythsandlegends.registry.MLSounds;
import java.util.List;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;

public class ShockwaveAttackGoal
extends Goal {
    private final GargoyleEntity mob;
    LivingEntity target;
    private int SHOCKWAVE_COOLDOWN = 40;

    public ShockwaveAttackGoal(GargoyleEntity mob) {
        this.mob = mob;
    }

    public boolean canUse() {
        this.target = this.mob.getTarget();
        return this.target != null && this.target.isAlive() && this.mob.isAwake && this.mob.distanceTo((Entity)this.target) <= 4.0f && !this.mob.isDeadOrDying();
    }

    public boolean canContinueToUse() {
        return this.SHOCKWAVE_COOLDOWN < 0;
    }

    public void tick() {
        if (this.SHOCKWAVE_COOLDOWN > 0) {
            --this.SHOCKWAVE_COOLDOWN;
        } else {
            this.performShockwaveAttack();
        }
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void stop() {
        this.target = null;
    }

    void performShockwaveAttack() {
        this.mob.triggerAnim("attackController", "shockwave");
        Level level = this.mob.level();
        List entities = level.getEntities((Entity)this.mob, this.mob.getBoundingBox().inflate(4.0));
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity)) continue;
            double deltaX = entity.getX() - this.mob.getX();
            double deltaZ = entity.getZ() - this.mob.getZ();
            double distance = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
            entity.hurt(level.damageSources().mobAttack((LivingEntity)this.mob), 5.0f);
            if (distance == 0.0) continue;
            ((LivingEntity)entity).knockback(3.0, -deltaX / distance, -deltaZ / distance);
        }
        level.broadcastEntityEvent((Entity)this.mob, (byte)69);
        this.SHOCKWAVE_COOLDOWN = 80;
        level.playSound(null, this.mob.getX(), this.mob.getY(), this.mob.getZ(), MLSounds.SHOCKWAVE.get(), SoundSource.HOSTILE);
    }
}

