/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity.goal.imp;

import com.ovinter.mythsandlegends.entity.ImpEntity;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class AttackGoal
extends Goal {
    private final ImpEntity imp;
    LivingEntity target;

    public AttackGoal(ImpEntity imp) {
        this.imp = imp;
    }

    public boolean canUse() {
        this.target = this.imp.getTarget();
        return this.target != null && this.target.isAlive() && !this.imp.getMoveControl().hasWanted() && this.imp.getRandom().nextInt(AttackGoal.reducedTickDelay((int)7)) == 0 && this.imp.distanceToSqr((Entity)this.target) > 3.0;
    }

    public boolean canContinueToUse() {
        return this.imp.getMoveControl().hasWanted() && this.target != null && this.target.isAlive();
    }

    public void start() {
        Vec3 vec3 = this.target.getEyePosition();
        this.imp.getMoveControl().setWantedPosition(vec3.x, vec3.y, vec3.z, 1.0);
        this.imp.playSound(SoundEvents.VEX_CHARGE, 1.0f, 0.6f);
    }

    public void stop() {
        this.target = null;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        if (this.imp.getBoundingBox().intersects(this.target.getBoundingBox())) {
            this.imp.doHurtTarget((Entity)this.target);
            this.imp.triggerAnim("attackController", "attack");
            this.target.addEffect(new MobEffectInstance(MobEffects.WITHER, 200, 0));
        } else {
            double distance = this.imp.distanceToSqr((Entity)this.target);
            if (distance < 9.0) {
                Vec3 vec3 = this.target.getEyePosition();
                this.imp.getMoveControl().setWantedPosition(vec3.x, vec3.y, vec3.z, 1.1);
            }
        }
    }
}

