/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity.goal.imp;

import com.ovinter.mythsandlegends.entity.ImpEntity;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.phys.Vec3;

public class FireballAttackGoal
extends Goal {
    private final ImpEntity imp;
    private int ATTACK_COOLDOWN = 20;

    public FireballAttackGoal(ImpEntity pEntity) {
        this.imp = pEntity;
    }

    public boolean canUse() {
        LivingEntity target = this.imp.getTarget();
        return target != null && this.imp.canAttack(target);
    }

    public void tick() {
        LivingEntity target;
        if (this.ATTACK_COOLDOWN > 0) {
            --this.ATTACK_COOLDOWN;
        }
        if ((target = this.imp.getTarget()) != null) {
            this.imp.getLookControl().setLookAt((Entity)target, 10.0f, 10.0f);
            if (this.ATTACK_COOLDOWN <= 0) {
                this.castFireball(target);
                this.ATTACK_COOLDOWN = 100;
            }
        }
    }

    void castFireball(LivingEntity pTarget) {
        if (this.imp.level().isClientSide) {
            return;
        }
        double dirX = pTarget.getX() - this.imp.getX();
        double dirY = pTarget.getY(0.5) - this.imp.getY(0.5);
        double dirZ = pTarget.getZ() - this.imp.getZ();
        Vec3 pos = new Vec3(dirX, dirY, dirZ);
        SmallFireball fireball = new SmallFireball(this.imp.level(), (LivingEntity)this.imp, pos);
        fireball.setPos(this.imp.getX(), this.imp.getY(0.5), this.imp.getZ());
        this.imp.level().addFreshEntity((Entity)fireball);
        this.imp.triggerAnim("attackController", "shoot");
        this.imp.playSound(SoundEvents.BLAZE_SHOOT, 1.0f, 1.0f);
    }
}

