/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.event;

import com.mojang.blaze3d.systems.RenderSystem;
import com.ovinter.mythsandlegends.client.gui.BossBar;
import com.ovinter.mythsandlegends.registry.MLEffects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.LerpingBossEvent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.CustomizeGuiOverlayEvent;
import net.neoforged.neoforge.client.event.RenderLivingEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;

@EventBusSubscriber(modid="mythsandlegends", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class EventBusClientEvents {
    private static final ResourceLocation BAR_BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)"textures/gui/sprites/bar/background.png");

    @SubscribeEvent
    public static void onEntityRenderer(RenderLivingEvent.Pre<LivingEntity, ?> event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (player = (Player)livingEntity).hasEffect(MLEffects.PETRIFIED)) {
            RenderSystem.setShaderColor((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
        }
    }

    @SubscribeEvent
    public static void onEntityRenderPost(RenderLivingEvent.Post<LivingEntity, ?> event) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @SubscribeEvent
    public static void onAttackEntity(AttackEntityEvent event) {
        Player player;
        Player player2 = event.getEntity();
        if (player2 instanceof Player && (player = player2).hasEffect(MLEffects.PETRIFIED)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onCustomGuiOverlay(CustomizeGuiOverlayEvent.BossEventProgress event) {
        LerpingBossEvent bossEvent = event.getBossEvent();
        String bossName = bossEvent.getName().getString();
        if (bossName.equals("The Black Charro")) {
            event.setCanceled(true);
            BossBar blackCharroBossBar = BossBar.bossBarMap.get("The Black Charro");
            if (blackCharroBossBar != null) {
                EventBusClientEvents.prepareBossBar(event, blackCharroBossBar);
            }
        }
    }

    private static void prepareBossBar(CustomizeGuiOverlayEvent.BossEventProgress event, BossBar BossBar2) {
        event.setIncrement(BossBar2.getIncrement());
        EventBusClientEvents.renderHealthBar(event, BossBar2.getBarHealthOffsetX(), event.getY() + BossBar2.getBarHealthPosY() - 12, BossBar2.getBarHealthWidth(), BossBar2.getBarHealthHeight(), BossBar2.getBarColor());
        EventBusClientEvents.renderBarOverlay(event.getY() + BossBar2.getBarOverlayPosY() - 12, BossBar2.getBarOverlayWidth(), BossBar2.getBarOverlayHeight(), BossBar2.getBarOverlay());
    }

    private static void renderHealthBar(CustomizeGuiOverlayEvent.BossEventProgress event, int OffsetX, int y, int Width, int Height, ResourceLocation barColor) {
        LerpingBossEvent bossEvent = event.getBossEvent();
        int x = (Minecraft.getInstance().getWindow().getGuiScaledWidth() - Width) / 2 + OffsetX;
        Minecraft minecraft = Minecraft.getInstance();
        MultiBufferSource.BufferSource bufferSource = minecraft.renderBuffers().bufferSource();
        GuiGraphics guiGraphics = new GuiGraphics(minecraft, bufferSource);
        guiGraphics.blit(BAR_BACKGROUND, x, y, 0.0f, 0.0f, Width, Height, Width, Height);
        if (bossEvent.getProgress() > 0.0f) {
            guiGraphics.blit(barColor, x, y, 0.0f, 0.0f, (int)(bossEvent.getProgress() * (float)Width), Height, Width, Height);
        }
    }

    public static void renderBarOverlay(int y, int Width, int Height, ResourceLocation BOSS_TEXTURE) {
        Minecraft minecraft = Minecraft.getInstance();
        MultiBufferSource.BufferSource bufferSource = minecraft.renderBuffers().bufferSource();
        GuiGraphics guiGraphics = new GuiGraphics(minecraft, bufferSource);
        int x = (minecraft.getWindow().getGuiScaledWidth() - Width) / 2;
        guiGraphics.blit(BOSS_TEXTURE, x, y, 0.0f, 0.0f, Width, Height, Width, Height);
    }
}

