/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.event;

import com.ovinter.mythsandlegends.api.util.SendMessageToPlayer;
import com.ovinter.mythsandlegends.entity.BlackCharroEntity;
import com.ovinter.mythsandlegends.registry.MLEffects;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;

@EventBusSubscriber(modid="mythsandlegends", bus=EventBusSubscriber.Bus.GAME)
public class EventBusNeoForgeEvents {
    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            DamageSource damageSource = event.getSource();
            if (damageSource.getEntity() instanceof BlackCharroEntity) {
                SendMessageToPlayer.sendRandomMessage("kills_player", player);
            }
            if (player.hasEffect(MLEffects.PETRIFIED)) {
                player.removeEffect(MLEffects.PETRIFIED);
                AttributeInstance movementSpeed = player.getAttribute(Attributes.MOVEMENT_SPEED);
                AttributeInstance jumpStrength = player.getAttribute(Attributes.JUMP_STRENGTH);
                if (movementSpeed != null && jumpStrength != null) {
                    movementSpeed.setBaseValue(0.1);
                    jumpStrength.setBaseValue(0.4);
                }
            }
        }
    }
}

