/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.item.armor;

import com.google.common.collect.ImmutableMap;
import com.ovinter.mythsandlegends.client.renderer.item.BoundSoulArmorRenderer;
import com.ovinter.mythsandlegends.registry.MLArmorMaterials;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class BoundSoulArmorItem
extends ArmorItem
implements GeoItem {
    private AnimatableInstanceCache geoCache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("IDLE");
    private static final Map<Holder<ArmorMaterial>, List<MobEffectInstance>> MATERIAL_TO_EFFECT_MAP = new ImmutableMap.Builder().put(MLArmorMaterials.BOUND_SOUL_ARMOR_MATERIAL, List.of(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 200, 0, false, false))).build();

    public BoundSoulArmorItem(Holder<ArmorMaterial> pMaterial, ArmorItem.Type pType, Item.Properties pProperties) {
        super(pMaterial, pType, pProperties);
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(this){
            private BoundSoulArmorRenderer renderer;

            public <T extends LivingEntity> HumanoidModel<?> getGeoArmorRenderer(@Nullable T livingEntity, ItemStack itemStack, @Nullable EquipmentSlot equipmentSlot, @Nullable HumanoidModel<T> original) {
                if (this.renderer == null) {
                    this.renderer = new BoundSoulArmorRenderer();
                }
                return this.renderer;
            }
        });
    }

    public void inventoryTick(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        if (pEntity instanceof Player) {
            Player player = (Player)pEntity;
            if (!pLevel.isClientSide() && this.hasFullSuitOfArmorOn(player)) {
                this.evaluateArmorEffects(player);
            }
        }
        super.inventoryTick(pStack, pLevel, pEntity, pSlotId, pIsSelected);
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        if (Screen.hasShiftDown()) {
            pTooltipComponents.add((Component)Component.translatable((String)"tooltip.mythsandlegends.bound_soul_armor_tooltip_shift_down"));
            pTooltipComponents.add((Component)Component.translatable((String)"tooltip.mythsandlegends.bound_soul_armor_tooltip_shift_down2"));
        } else {
            pTooltipComponents.add((Component)Component.translatable((String)"tooltip.mythsandlegends.bound_soul_armor_tooltip"));
        }
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
    }

    private void evaluateArmorEffects(Player player) {
        for (Map.Entry<Holder<ArmorMaterial>, List<MobEffectInstance>> entry : MATERIAL_TO_EFFECT_MAP.entrySet()) {
            Holder<ArmorMaterial> mapArmorMaterial = entry.getKey();
            List<MobEffectInstance> mapEffect = entry.getValue();
            if (!this.hasPlayerCorrectArmorOn(mapArmorMaterial, player)) continue;
            int amplifier = player.level().isNight() ? 1 : 0;
            this.addEffectToPlayer(player, mapEffect, amplifier);
        }
    }

    private void addEffectToPlayer(Player player, List<MobEffectInstance> mapEffect, int amplifier) {
        boolean hasPlayerEffect = mapEffect.stream().allMatch(effect -> player.hasEffect(effect.getEffect()));
        if (!hasPlayerEffect) {
            for (MobEffectInstance effect2 : mapEffect) {
                player.addEffect(new MobEffectInstance(effect2.getEffect(), effect2.getDuration(), amplifier, effect2.isAmbient(), effect2.isVisible()));
            }
        }
    }

    private boolean hasPlayerCorrectArmorOn(Holder<ArmorMaterial> mapArmorMaterial, Player player) {
        for (ItemStack armorStack : player.getArmorSlots()) {
            if (armorStack.getItem() instanceof BoundSoulArmorItem) continue;
            return false;
        }
        BoundSoulArmorItem boots = (BoundSoulArmorItem)player.getInventory().getArmor(0).getItem();
        BoundSoulArmorItem leggings = (BoundSoulArmorItem)player.getInventory().getArmor(1).getItem();
        BoundSoulArmorItem chestplate = (BoundSoulArmorItem)player.getInventory().getArmor(2).getItem();
        BoundSoulArmorItem helmet = (BoundSoulArmorItem)player.getInventory().getArmor(3).getItem();
        return boots.getMaterial() == mapArmorMaterial && leggings.getMaterial() == mapArmorMaterial && chestplate.getMaterial() == mapArmorMaterial && helmet.getMaterial() == mapArmorMaterial;
    }

    private boolean hasFullSuitOfArmorOn(Player player) {
        ItemStack boots = player.getInventory().getArmor(0);
        ItemStack leggings = player.getInventory().getArmor(1);
        ItemStack chestplate = player.getInventory().getArmor(2);
        ItemStack helmet = player.getInventory().getArmor(3);
        return !boots.isEmpty() && !leggings.isEmpty() && !chestplate.isEmpty() && !helmet.isEmpty();
    }

    private PlayState predicate(AnimationState<?> state) {
        state.getController().setAnimation(IDLE);
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }
}

