/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.registry;

import com.ovinter.mythsandlegends.entity.BlackCharroEntity;
import com.ovinter.mythsandlegends.entity.GargoyleEntity;
import com.ovinter.mythsandlegends.entity.ImpCloneEntity;
import com.ovinter.mythsandlegends.entity.ImpEntity;
import com.ovinter.mythsandlegends.entity.PossessedArmorEntity;
import com.ovinter.mythsandlegends.entity.projectile.UmbralOrbEntity;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.neoforge.registries.DeferredRegister;

public class MLEntities {
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"mythsandlegends");
    public static final Supplier<EntityType<ImpEntity>> IMP = MLEntities.register("imp", ImpEntity::new, MobCategory.MONSTER, 0.4f, 0.7f, 0.55f);
    public static final Supplier<EntityType<ImpCloneEntity>> IMP_CLONE = MLEntities.register("imp_clone", ImpCloneEntity::new, MobCategory.MONSTER, 0.4f, 0.7f, 0.55f);
    public static final Supplier<EntityType<PossessedArmorEntity>> POSSESSED_ARMOR = MLEntities.register("possessed_armor", PossessedArmorEntity::new, MobCategory.MONSTER, 0.8f, 2.0f, 1.7f);
    public static final Supplier<EntityType<GargoyleEntity>> GARGOYLE = MLEntities.register("gargoyle", GargoyleEntity::new, MobCategory.MONSTER, 0.9f, 1.7f, 1.6f);
    public static final Supplier<EntityType<BlackCharroEntity>> BLACK_CHARRO = MLEntities.register("black_charro", BlackCharroEntity::new, MobCategory.MONSTER, 0.8f, 2.0f, 1.7f);
    public static final Supplier<EntityType<UmbralOrbEntity>> UMBRAL_ORB = MLEntities.register("umbral_orb", UmbralOrbEntity::new, MobCategory.MISC, 0.5f, 0.5f, 0.0f);

    private static <e extends Entity> Supplier<EntityType<e>> register(String name, EntityType.EntityFactory<e> entity, MobCategory category, float width, float height, float eyeHeight) {
        return ENTITY_TYPES.register(name, () -> EntityType.Builder.of((EntityType.EntityFactory)entity, (MobCategory)category).sized(width, height).eyeHeight(eyeHeight).build(String.valueOf(ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)name))));
    }
}

