/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.ovinter.mythsandlegends.client.model.entity.ImpModel;
import com.ovinter.mythsandlegends.entity.ImpEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.BlockAndItemGeoLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class ImpRenderer<T extends ImpEntity>
extends GeoEntityRenderer<T> {
    public ImpRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, new ImpModel());
        this.shadowRadius = 0.5f;
        this.addRenderLayer((GeoRenderLayer)new BlockAndItemGeoLayer<T>(this, (GeoRenderer)this){

            @Nullable
            protected ItemStack getStackForBone(GeoBone bone, T animatable) {
                return switch (bone.getName()) {
                    case "right_hand" -> animatable.getMainHandItem();
                    default -> null;
                };
            }

            protected ItemDisplayContext getTransformTypeForStack(GeoBone bone, ItemStack stack, T animatable) {
                return switch (bone.getName()) {
                    case "right_hand" -> ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
                    default -> ItemDisplayContext.NONE;
                };
            }

            protected void renderStackForBone(PoseStack poseStack, GeoBone bone, ItemStack stack, T animatable, MultiBufferSource bufferSource, float partialTick, int packedLight, int packedOverlay) {
                if (stack == animatable.getMainHandItem()) {
                    poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                    poseStack.scale(0.5f, 0.5f, 0.5f);
                    poseStack.translate(0.0, 0.0, 0.0);
                }
                super.renderStackForBone(poseStack, bone, stack, animatable, bufferSource, partialTick, packedLight, packedOverlay);
            }
        });
    }

    protected int getBlockLightLevel(T pEntity, BlockPos pPos) {
        return 15;
    }

    public RenderType getRenderType(T animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        return RenderType.entityTranslucent((ResourceLocation)texture);
    }
}

