/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.datagen;

import com.ovinter.mythsandlegends.registry.MLItems;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.KilledTrigger;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.data.AdvancementProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class MLAdvancementProvider
extends AdvancementProvider {
    public MLAdvancementProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, ExistingFileHelper existingFileHelper) {
        super(output, registries, existingFileHelper, List.of(new MLAdvancementGenerator()));
    }

    private static class MLAdvancementGenerator
    implements AdvancementProvider.AdvancementGenerator {
        private MLAdvancementGenerator() {
        }

        public void generate(HolderLookup.Provider registries, Consumer<AdvancementHolder> consumer, ExistingFileHelper fileHelper) {
            AdvancementHolder root = Advancement.Builder.advancement().display((ItemLike)MLItems.CURSED_CORE.get(), (Component)Component.translatable((String)"advancements.mythsandlegends.root.title"), (Component)Component.translatable((String)"advancements.mythsandlegends.root.description"), ResourceLocation.withDefaultNamespace((String)"textures/block/blackstone.png"), AdvancementType.TASK, false, false, false).addCriterion("mythsandlegends", PlayerTrigger.TriggerInstance.tick()).save(consumer, MLAdvancementGenerator.id("root"));
            AdvancementHolder cursedPower = MLAdvancementGenerator.createItemAdvancement("cursed_power", (Item)MLItems.CURSED_CORE.get(), root, consumer);
            AdvancementHolder boundSoulIngot = MLAdvancementGenerator.createItemAdvancement("bound_soul_ingot", (Item)MLItems.BOUND_SOUL_INGOT.get(), cursedPower, consumer);
            AdvancementHolder shardCollector = MLAdvancementGenerator.createItemAdvancement("shard_collector", (Item)MLItems.GARGOYLE_SHARD.get(), root, consumer);
            AdvancementHolder fragmentOfPower = MLAdvancementGenerator.createItemAdvancement("fragment_of_power", (Item)MLItems.GARGOYLE_FRAGMENT.get(), root, consumer);
            AdvancementHolder warbornConqueror = MLAdvancementGenerator.createEntityKillAdvancement("warborn_conqueror", (Item)MLItems.INFERNUM_WARPLATE_HELMET.get(), MLAdvancementGenerator.id("warborn_aegis"), root, consumer);
            AdvancementHolder echoInTheFrost = MLAdvancementGenerator.createEntityKillAdvancement("echo_in_the_frost", (Item)MLItems.KARAKONDJUL_HORN.get(), MLAdvancementGenerator.id("karakondjul"), root, consumer);
            MLAdvancementGenerator.createItemAdvancement("bound_by_darkness", (Item)MLItems.IRONSHADE_HELMET.get(), boundSoulIngot, consumer);
            MLAdvancementGenerator.createItemAdvancement("heart_of_fire", (Item)MLItems.FIRE_HEART.get(), root, consumer);
            MLAdvancementGenerator.createEntityKillAdvancement("rider_of_the_shadows", (Item)MLItems.SOULBINDER_AMULET.get(), MLAdvancementGenerator.id("black_charro"), root, consumer);
            MLAdvancementGenerator.createEquipmentAdvancement("the_stonewall", (Item)MLItems.STONY_SHIELD.get(), fragmentOfPower, consumer);
            MLAdvancementGenerator.createEquipmentAdvancement("master_of_the_blade", (Item)MLItems.GARGOYLE_AXE.get(), shardCollector, consumer);
            MLAdvancementGenerator.createEquipmentAdvancement("forged_in_inferno", (Item)MLItems.INFERNUM_WARPLATE_CHESTPLATE.get(), warbornConqueror, consumer);
            MLAdvancementGenerator.createEquipmentAdvancement("aegis_of_the_damned", (Item)MLItems.MALEDICTUM_SHIELD.get(), warbornConqueror, consumer);
            MLAdvancementGenerator.createItemAdvancement("frozen_heart", (Item)MLItems.FROZEN_HEART.get(), echoInTheFrost, consumer);
            MLAdvancementGenerator.createItemAdvancement("relic_of_the_forge_god", (Item)MLItems.SVAROGS_RING.get(), root, consumer);
        }

        private static String id(String name) {
            return ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)name).toString();
        }

        private static AdvancementHolder createItemAdvancement(String name, Item item, AdvancementHolder parent, Consumer<AdvancementHolder> consumer) {
            return Advancement.Builder.advancement().parent(parent).display((ItemLike)item, (Component)Component.translatable((String)("advancements.mythsandlegends." + name + ".title")), (Component)Component.translatable((String)("advancements.mythsandlegends." + name + ".description")), null, AdvancementType.TASK, true, true, false).addCriterion("obtain_" + name, InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{item})).save(consumer, MLAdvancementGenerator.id(name));
        }

        private static AdvancementHolder createEntityKillAdvancement(String name, Item displayItem, String entityId, AdvancementHolder parent, Consumer<AdvancementHolder> consumer) {
            return Advancement.Builder.advancement().parent(parent).display((ItemLike)displayItem, (Component)Component.translatable((String)("advancements.mythsandlegends." + name + ".title")), (Component)Component.translatable((String)("advancements.mythsandlegends." + name + ".description")), null, AdvancementType.CHALLENGE, true, true, false).addCriterion("kill_" + name, KilledTrigger.TriggerInstance.playerKilledEntity((EntityPredicate.Builder)EntityPredicate.Builder.entity().of((EntityType)EntityType.byString((String)entityId).orElseThrow()))).save(consumer, MLAdvancementGenerator.id(name));
        }

        private static void createEquipmentAdvancement(String name, Item resultItem, AdvancementHolder parent, Consumer<AdvancementHolder> consumer) {
            Advancement.Builder.advancement().parent(parent).display((ItemLike)resultItem, (Component)Component.translatable((String)("advancements.mythsandlegends." + name + ".title")), (Component)Component.translatable((String)("advancements.mythsandlegends." + name + ".description")), null, AdvancementType.GOAL, true, true, false).addCriterion("craft_" + name, InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{resultItem})).save(consumer, MLAdvancementGenerator.id(name));
        }
    }
}

