/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity;

import com.ovinter.mythsandlegends.Config;
import com.ovinter.mythsandlegends.api.util.ParticleGeneratorHelper;
import com.ovinter.mythsandlegends.config.DefaultMobAttributes;
import com.ovinter.mythsandlegends.entity.MLEntity;
import com.ovinter.mythsandlegends.entity.ai.goal.abaddon.MoltenSpikesGoal;
import com.ovinter.mythsandlegends.entity.ai.goal.generic.AnimatedMeleeAttackGoal;
import com.ovinter.mythsandlegends.entity.ai.goal.generic.ChaseTargetGoal;
import com.ovinter.mythsandlegends.registry.MLSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class AbaddonEntity
extends MLEntity {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final RawAnimation IDLE_ANIM = RawAnimation.begin().thenLoop("IDLE");
    private final RawAnimation WALK_ANIM = RawAnimation.begin().thenLoop("WALK");
    private final RawAnimation ATTACK_ANIM = RawAnimation.begin().thenPlay("ATTACK");
    private final RawAnimation RANGED_ATTACK_ANIM = RawAnimation.begin().thenPlay("RANGED_ATTACK");
    private final RawAnimation DEATH_ANIM = RawAnimation.begin().thenPlay("DEATH");
    public int moltenSpikeCooldown;
    public final int MOLTEN_SPIKE_COOLDOWN = 200;

    public AbaddonEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
        this.setPathfindingMalus(PathType.LAVA, 0.0f);
        this.setPathfindingMalus(PathType.DANGER_FIRE, 0.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, 0.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, DefaultMobAttributes.ABADDON_HEALTH).add(Attributes.ARMOR, DefaultMobAttributes.ABADDON_ARMOR).add(Attributes.ATTACK_DAMAGE, DefaultMobAttributes.ABADDON_DAMAGE).add(Attributes.MOVEMENT_SPEED, DefaultMobAttributes.ABADDON_MOVEMENT).add(Attributes.FOLLOW_RANGE, DefaultMobAttributes.ABADDON_FOLLOW_RANGE);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(4, (Goal)new MoltenSpikesGoal(this));
        this.goalSelector.addGoal(5, (Goal)new AnimatedMeleeAttackGoal(this, 20, 8, 3.0f));
        this.goalSelector.addGoal(5, (Goal)new ChaseTargetGoal(this, false, 1.2));
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.2));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 12.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractPiglin.class, true));
    }

    public void tick() {
        if (this.moltenSpikeCooldown > 0) {
            --this.moltenSpikeCooldown;
        }
        this.floatAbaddon();
        this.checkInsideBlocks();
        if (this.level().isClientSide && this.getAnimationId() == 2) {
            ParticleGeneratorHelper.generateCircleParticles(this.level(), (LivingEntity)this, ParticleTypes.SMALL_FLAME, 0.3, 1.2);
        }
        super.tick();
    }

    protected void customServerAiStep() {
        if (this.getAttackTicks() > 0) {
            this.setAttackTicks(this.getAttackTicks() - 1);
        }
        super.customServerAiStep();
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        this.setConfigAttributes();
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    public boolean isAlliedTo(Entity entity) {
        if (entity == this) {
            return true;
        }
        if (entity.getClass() == this.getClass()) {
            return true;
        }
        return super.isAlliedTo(entity);
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    public boolean isOnFire() {
        return false;
    }

    public boolean fireImmune() {
        return true;
    }

    public boolean isSensitiveToWater() {
        return true;
    }

    public boolean canStandOnFluid(FluidState pFluidState) {
        return pFluidState.is(FluidTags.LAVA);
    }

    public boolean causeFallDamage(float fallDistance, float multiplier, DamageSource source) {
        return false;
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader level) {
        if (level.getBlockState(pos).getFluidState().is(FluidTags.LAVA)) {
            return 10.0f;
        }
        return this.isInLava() ? Float.NEGATIVE_INFINITY : 0.0f;
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)MLSounds.ABADDON_AMBIENT.value();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)MLSounds.ABADDON_HURT.value();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)MLSounds.ABADDON_DEATH.value();
    }

    protected void playAttackSound() {
        this.playSound((SoundEvent)MLSounds.ABADDON_ATTACK.value());
    }

    @Override
    PlayState movementPredicate(AnimationState<?> state) {
        if (this.isDeadOrDying()) {
            return state.setAndContinue(this.DEATH_ANIM);
        }
        if (this.getAnimationId() == 2) {
            return state.setAndContinue(this.RANGED_ATTACK_ANIM);
        }
        return state.isMoving() ? state.setAndContinue(this.WALK_ANIM) : state.setAndContinue(this.IDLE_ANIM);
    }

    @Override
    PlayState attackPredicate(AnimationState<?> state) {
        if (this.isDeadOrDying()) {
            return PlayState.STOP;
        }
        if (this.getAnimationId() == 1 && this.getAttackTicks() == 19 && this.isAlive()) {
            state.getController().forceAnimationReset();
            return state.setAndContinue(this.ATTACK_ANIM);
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "movementController", 5, this::movementPredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "attackController", 2, this::attackPredicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    @Override
    void setConfigAttributes() {
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(((Double)Config.ABADDON_HEALTH.get()).doubleValue());
        this.getAttribute(Attributes.ARMOR).setBaseValue(((Double)Config.ABADDON_ARMOR.get()).doubleValue());
        this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(((Double)Config.ABADDON_DAMAGE.get()).doubleValue());
        this.setHealth((float)Config.SCORCHED_SENTINEL_HEALTH.getAsDouble());
    }

    private void floatAbaddon() {
        if (this.isInLava()) {
            CollisionContext collisioncontext = CollisionContext.of((Entity)this);
            if (collisioncontext.isAbove(LiquidBlock.STABLE_SHAPE, this.blockPosition(), true) && !this.level().getFluidState(this.blockPosition().above()).is(FluidTags.LAVA)) {
                this.setOnGround(true);
            } else {
                this.setDeltaMovement(this.getDeltaMovement().scale(0.5).add(0.0, 0.05, 0.0));
            }
        }
    }
}

