/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity;

import com.ovinter.mythsandlegends.api.util.ParticleGeneratorHelper;
import com.ovinter.mythsandlegends.entity.MLEntity;
import com.ovinter.mythsandlegends.entity.PossessedArmorEntity;
import com.ovinter.mythsandlegends.registry.MLSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AbstractPossessedArmor
extends MLEntity {
    private static final EntityDataAccessor<Boolean> HAS_HALF_HEALTH = SynchedEntityData.defineId(AbstractPossessedArmor.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> HAS_PLAYED_HALF_HEALTH = SynchedEntityData.defineId(AbstractPossessedArmor.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public AbstractPossessedArmor(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.xpReward = 18;
    }

    public abstract ResourceLocation getModelResource();

    public abstract ResourceLocation getTextureResource();

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 12.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[]{PossessedArmorEntity.class}));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractGolem.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(HAS_HALF_HEALTH, (Object)false);
        pBuilder.define(HAS_PLAYED_HALF_HEALTH, (Object)false);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        if (pCompound.contains("Health")) {
            this.setHealth(pCompound.getFloat("Health"));
        }
    }

    @Override
    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putFloat("Health", this.getHealth());
    }

    public void tick() {
        if (this.onGround() && this.level().isClientSide()) {
            ParticleGeneratorHelper.generateDustParticles((LivingEntity)this, 0.0f, 0.0f, 0.0f, !this.getHasHalfHealth() ? 1.0f : 1.5f, false, false);
        }
        if (!this.level().isClientSide()) {
            boolean currentlyHalfHealth;
            boolean bl = currentlyHalfHealth = this.getHealth() <= this.getMaxHealth() / 2.0f;
            if (currentlyHalfHealth && !this.getHasHalfHealth()) {
                this.setHasHalfHealth(true);
            }
        }
        super.tick();
    }

    protected void customServerAiStep() {
        if (this.getAttackTicks() > 0) {
            this.setAttackTicks(this.getAttackTicks() - 1);
        }
        super.customServerAiStep();
    }

    protected void tickDeath() {
        ++this.deathTime;
        if (this.deathTime == 25 && !this.level().isClientSide() && !this.isRemoved()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)60);
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        if (this.getHealth() <= this.getMaxHealth() / 2.0f && !this.getHasPlayedHalfHealth()) {
            this.playSound(SoundEvents.CHAIN_BREAK, 10.0f, 0.3f);
            this.setHasPlayedHalfHealth(true);
            this.setHasHalfHealth(true);
        }
        return super.hurt(pSource, pAmount);
    }

    public boolean isAlliedTo(Entity entity) {
        if (entity == this) {
            return true;
        }
        if (entity instanceof AbstractPossessedArmor) {
            return true;
        }
        return super.isAlliedTo(entity);
    }

    public boolean isInvulnerableTo(DamageSource pSource) {
        return pSource.is(DamageTypeTags.IS_FIRE) || pSource.is(DamageTypeTags.IS_DROWNING);
    }

    protected SoundEvent getHurtSound(DamageSource pDamageSource) {
        return (SoundEvent)MLSounds.POSSESSED_ARMOR_HURT.value();
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)MLSounds.POSSESSED_ARMOR_AMBIENT.value();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)MLSounds.POSSESSED_ARMOR_DEATH.value();
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
    }

    public void setHasHalfHealth(boolean hasHalfHealth) {
        this.entityData.set(HAS_HALF_HEALTH, (Object)hasHalfHealth);
    }

    public boolean getHasHalfHealth() {
        return (Boolean)this.entityData.get(HAS_HALF_HEALTH);
    }

    public void setHasPlayedHalfHealth(boolean hasHalfHealth) {
        this.entityData.set(HAS_PLAYED_HALF_HEALTH, (Object)hasHalfHealth);
    }

    public boolean getHasPlayedHalfHealth() {
        return (Boolean)this.entityData.get(HAS_PLAYED_HALF_HEALTH);
    }
}

