/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity;

import com.ovinter.mythsandlegends.entity.WarbornAegisEntity;
import com.ovinter.mythsandlegends.registry.MLEntities;
import com.ovinter.mythsandlegends.registry.MLParticles;
import com.ovinter.mythsandlegends.registry.MLSounds;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class IgnisNexusEntity
extends Entity
implements GeoEntity {
    AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final RawAnimation IDLE = RawAnimation.begin().thenLoop("IDLE");
    private static final EntityDataAccessor<Optional<UUID>> BOSS_UUID = SynchedEntityData.defineId(IgnisNexusEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);

    public IgnisNexusEntity(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.blocksBuilding = true;
    }

    public IgnisNexusEntity(Level level, UUID bossUUID) {
        this(MLEntities.IGNIS_NEXUS.get(), level);
        this.entityData.set(BOSS_UUID, Optional.of(bossUUID));
    }

    PlayState predicate(AnimationState<?> state) {
        return state.setAndContinue(this.IDLE);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, this::predicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        pBuilder.define(BOSS_UUID, Optional.empty());
    }

    public void onRemovedFromLevel() {
        Entity boss;
        Optional bossUUID;
        super.onRemovedFromLevel();
        if (!this.level().isClientSide && (bossUUID = (Optional)this.entityData.get(BOSS_UUID)).isPresent() && (boss = ((ServerLevel)this.level()).getEntity((UUID)bossUUID.get())) instanceof WarbornAegisEntity) {
            ((WarbornAegisEntity)boss).onNexusDestroyed(this.getUUID());
        }
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        if (this.isInvulnerableTo(pSource)) {
            return false;
        }
        if (pSource.getEntity() instanceof WarbornAegisEntity) {
            return false;
        }
        if (!this.isRemoved() && !this.level().isClientSide) {
            this.remove(Entity.RemovalReason.KILLED);
            this.destroyNexus();
        }
        return true;
    }

    protected void readAdditionalSaveData(CompoundTag pCompound) {
        if (pCompound.hasUUID("BossUUID")) {
            this.entityData.set(BOSS_UUID, Optional.of(pCompound.getUUID("BossUUID")));
        }
    }

    protected void addAdditionalSaveData(CompoundTag pCompound) {
        if (((Optional)this.entityData.get(BOSS_UUID)).isPresent()) {
            pCompound.putUUID("BossUUID", (UUID)((Optional)this.entityData.get(BOSS_UUID)).get());
        }
    }

    public void tick() {
        LivingEntity boss;
        super.tick();
        if (this.tickCount % 5 == 0) {
            this.spawnSphereParticles((ParticleOptions)MLParticles.LAMPAD_BOOST_PARTICLE.get(), 1.5, 8);
        }
        if (this.level().isClientSide && (boss = this.getBoss()) != null && boss.isAlive()) {
            this.createBeamEffects(boss);
        }
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public boolean isPickable() {
        return true;
    }

    public boolean isInvulnerableTo(DamageSource pSource) {
        return false;
    }

    public LivingEntity getBoss() {
        Optional bossUUID = (Optional)this.getEntityData().get(BOSS_UUID);
        if (bossUUID.isPresent()) {
            if (!this.level().isClientSide) {
                Entity entity = ((ServerLevel)this.level()).getEntity((UUID)bossUUID.get());
                return entity instanceof LivingEntity ? (LivingEntity)entity : null;
            }
            AABB searchArea = new AABB(this.blockPosition()).inflate(32.0);
            for (LivingEntity entity : this.level().getEntitiesOfClass(LivingEntity.class, searchArea, e -> true)) {
                if (!entity.getUUID().equals(bossUUID.get())) continue;
                return entity;
            }
        }
        return null;
    }

    private void destroyNexus() {
        this.playSound((SoundEvent)MLSounds.IGNIS_NEXUS_DESTROYED.value(), 2.5f, 1.0f);
        this.spawnDestroyParticles();
    }

    private void createBeamEffects(LivingEntity boss) {
        Vec3 startPos = this.position().add(0.0, 1.5, 0.0);
        Vec3 endPos = boss.position().add(0.0, (double)(boss.getBbHeight() / 2.0f), 0.0);
        double distance = startPos.distanceTo(endPos);
        int particles = (int)(distance * 1.2);
        for (int i = 0; i <= particles; ++i) {
            double progress = (double)i / (double)particles;
            double x = Mth.lerp((double)progress, (double)startPos.x, (double)endPos.x);
            double y = Mth.lerp((double)progress, (double)startPos.y, (double)endPos.y);
            double z = Mth.lerp((double)progress, (double)startPos.z, (double)endPos.z);
            SimpleParticleType mainParticle = this.tickCount % 4 == 0 ? ParticleTypes.FLAME : (ParticleOptions)MLParticles.LAMPAD_BOOST_PARTICLE.get();
            this.level().addParticle((ParticleOptions)mainParticle, x += (this.random.nextDouble() - 0.5) * 0.2, y += (this.random.nextDouble() - 0.5) * 0.2, z += (this.random.nextDouble() - 0.5) * 0.2, (this.random.nextDouble() - 0.5) * 0.1, 0.05, (this.random.nextDouble() - 0.5) * 0.1);
        }
    }

    private void spawnSphereParticles(ParticleOptions particle, double radius, int count) {
        double centerY = this.getY() + (double)(this.getBbHeight() / 2.0f);
        for (int i = 0; i < count; ++i) {
            double theta = this.random.nextDouble() * 2.0 * Math.PI;
            double phi = Math.acos(2.0 * this.random.nextDouble() - 1.0);
            double xOffset = radius * Math.sin(phi) * Math.cos(theta);
            double yOffset = radius * Math.sin(phi) * Math.sin(theta);
            double zOffset = radius * Math.cos(phi);
            this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getX() + xOffset, centerY + yOffset, this.getZ() + zOffset, 0.0, 0.0, 0.0);
            this.level().addParticle(particle, this.getX() + xOffset, centerY + yOffset, this.getZ() + zOffset, 0.0, 0.0, 0.0);
        }
    }

    private void spawnDestroyParticles() {
        for (int i = 0; i < 10; ++i) {
            double xOffset = (this.random.nextDouble() - 0.5) * 2.0;
            double yOffset = (this.random.nextDouble() - 0.5) * 2.0;
            double zOffset = (this.random.nextDouble() - 0.5) * 2.0;
            this.level().addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, this.getX() + xOffset, this.getY() + yOffset, this.getZ() + zOffset, 0.0, 0.1, 0.0);
        }
    }
}

