/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity.ai.goal.black_charro;

import com.ovinter.mythsandlegends.entity.BlackCharroEntityOld;
import com.ovinter.mythsandlegends.registry.MLSounds;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public class TeleportGoal
extends Goal {
    private final BlackCharroEntityOld mob;
    private LivingEntity target;

    public TeleportGoal(BlackCharroEntityOld mob) {
        this.mob = mob;
    }

    public boolean canUse() {
        this.target = this.mob.getTarget();
        return this.target != null && this.mob.getRandom().nextInt(100) < this.mob.getTeleportChance() && !this.mob.hasEffect(MobEffects.REGENERATION);
    }

    public void start() {
        double targetZ;
        double targetY;
        double angle = this.mob.getRandom().nextDouble() * 2.0 * Math.PI;
        double distance = this.mob.getRandom().nextDouble() * 10.0;
        double offsetX = Math.cos(angle) * distance;
        double offsetZ = Math.sin(angle) * distance;
        double targetX = this.mob.getX() + offsetX;
        if (this.mob.isValidTeleportLocation(targetX, targetY = this.mob.getY(), targetZ = this.mob.getZ() + offsetZ)) {
            this.mob.triggerAnim("controller", "teleport");
            this.mob.level().broadcastEntityEvent((Entity)this.mob, (byte)69);
            this.mob.teleportTo(targetX, targetY, targetZ);
            this.mob.playSound((SoundEvent)MLSounds.BLACK_CHARRO_TELEPORT.value(), 1.0f, 1.0f);
        }
    }
}

