/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity.ai.goal.inquisitor;

import com.ovinter.mythsandlegends.entity.PossessedArmorInquisitorEntity;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;

public class StunLockGoal
extends Goal {
    private final PossessedArmorInquisitorEntity mob;
    private int tickCount;

    public StunLockGoal(PossessedArmorInquisitorEntity pMob) {
        this.mob = pMob;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        return this.mob.isStunned();
    }

    public boolean canContinueToUse() {
        return this.mob.isStunned();
    }

    public void start() {
        this.mob.setTarget(null);
        this.mob.getNavigation().stop();
        this.mob.setAnimationId(this.mob.STUN);
        this.mob.setDeltaMovement(0.0, this.mob.getDeltaMovement().y, 0.0);
        this.mob.getLookControl().setLookAt((Entity)this.mob);
        this.tickCount = 0;
    }

    public void tick() {
        ++this.tickCount;
        this.mob.setTarget(null);
        this.mob.getNavigation().stop();
        this.mob.setDeltaMovement(0.0, this.mob.getDeltaMovement().y, 0.0);
        if (this.tickCount % 2 == 0) {
            this.mob.level().broadcastEntityEvent((Entity)this.mob, (byte)70);
        }
        if (this.mob.getStunTicks() == 0) {
            this.stop();
        }
    }

    public void stop() {
        this.mob.setAnimationId(0);
        this.mob.setStunned(false);
        this.tickCount = 0;
    }
}

