/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity.ai.goal.inquisitor;

import com.ovinter.mythsandlegends.entity.MLEntity;
import com.ovinter.mythsandlegends.entity.PossessedArmorEntity;
import com.ovinter.mythsandlegends.entity.PossessedArmorInquisitorEntity;
import com.ovinter.mythsandlegends.registry.MLEntities;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.ServerLevelAccessor;

public class SummonMinionsGoal<T extends MLEntity>
extends Goal {
    private final PossessedArmorInquisitorEntity mob;
    private LivingEntity target;
    private Class<T> entity;
    private int minionCount;
    private int currentWave;
    private int waves;
    private int baseWaveDelay;
    private int waveDelay = 40;

    public SummonMinionsGoal(PossessedArmorInquisitorEntity pMob, int pMinionCount, int pWaves, int pWaveDelay, Class<T> pEntity) {
        this.mob = pMob;
        this.minionCount = pMinionCount;
        this.waves = pWaves;
        this.baseWaveDelay = pWaveDelay;
        this.entity = pEntity;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        this.target = this.mob.getTarget();
        return this.target != null && this.target.isAlive() && this.mob.onGround() && !this.mob.isDeadOrDying() && !this.mob.isStunned() && this.mob.summonCooldown == 0 && this.mob.getHasHalfHealth();
    }

    public boolean canContinueToUse() {
        return this.target != null && this.target.isAlive() && this.mob.isAlive();
    }

    public void start() {
        this.mob.setAnimationId(this.mob.SUMMON);
        this.mob.getNavigation().stop();
        this.currentWave = 0;
    }

    public void stop() {
        this.target = null;
        this.mob.setAnimationId(0);
        this.mob.getNavigation().recomputePath();
        this.mob.summonCooldown = this.mob.SUMMON_COOLDOWN;
        this.currentWave = 0;
    }

    public void tick() {
        if (this.target == null) {
            return;
        }
        this.mob.getLookControl().setLookAt((Entity)this.target);
        this.mob.getLookControl().tick();
        --this.waveDelay;
        if (this.currentWave < this.waves) {
            if (this.waveDelay <= 0) {
                this.mob.playSummonSound();
                this.summonMinion();
                this.waveDelay = this.baseWaveDelay;
                ++this.currentWave;
            }
        } else if (this.currentWave == this.waves && this.waveDelay <= 0) {
            this.stop();
        }
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    void summonMinion() {
        if (this.entity == PossessedArmorEntity.class) {
            for (int i = 0; i < this.minionCount; ++i) {
                PossessedArmorEntity minion = new PossessedArmorEntity(MLEntities.POSSESSED_ARMOR.get(), this.mob.level());
                minion.finalizeSpawn((ServerLevelAccessor)this.mob.level(), this.mob.level().getCurrentDifficultyAt(this.mob.blockPosition()), MobSpawnType.MOB_SUMMONED, null);
                double offsetX = (this.mob.getRandom().nextDouble() - 0.5) * 5.0;
                double offsetZ = (this.mob.getRandom().nextDouble() - 0.5) * 5.0;
                minion.setPos(this.mob.getX() + offsetX, this.mob.getY(), this.mob.getZ() + offsetZ);
                this.mob.level().addFreshEntity((Entity)minion);
            }
        }
    }
}

