/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity.ai.goal.karakondjul;

import com.ovinter.mythsandlegends.entity.KarakondjulEntity;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;

public class SleepGoal
extends Goal {
    private final KarakondjulEntity mob;
    private int sleepTicks;
    private int maxSleepTicks;

    public SleepGoal(KarakondjulEntity pMob) {
        this.mob = pMob;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        return (double)this.mob.getHealth() < (double)this.mob.getMaxHealth() * 0.5 && this.mob.getRandom().nextInt(100) < 2;
    }

    public void start() {
        this.mob.getNavigation().stop();
        this.mob.setIsSleeping(true);
        this.maxSleepTicks = this.mob.getRandom().nextInt(101) + 100;
        this.mob.setAnimationId(this.mob.SLEEP);
        this.sleepTicks = 0;
    }

    public void tick() {
        ++this.sleepTicks;
        if (this.sleepTicks % 40 == 0) {
            this.mob.heal(1.0f);
            this.mob.level().broadcastEntityEvent((Entity)this.mob, (byte)69);
        }
    }

    public boolean canContinueToUse() {
        return this.sleepTicks < this.maxSleepTicks;
    }

    public void stop() {
        this.mob.setAnimationId(0);
        this.mob.setIsSleeping(false);
        this.mob.getNavigation().recomputePath();
        this.sleepTicks = 0;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }
}

