/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity.ai.navigation;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class FlyingNavigation
extends FlyingPathNavigation {
    private int obstacleCheckCooldown = 0;
    private Vec3 lastEscapeDirection = Vec3.ZERO;

    public FlyingNavigation(Mob entity, Level level) {
        super(entity, level);
    }

    protected void followThePath() {
        if (this.obstacleCheckCooldown <= 0) {
            Vec3 currentPos = this.mob.position();
            BlockPos obstacle = this.findObstacle(currentPos, 3);
            if (obstacle != null) {
                this.lastEscapeDirection = this.calculateEscapeVector(currentPos, obstacle);
                this.replanPathAwayFromObstacle(currentPos, this.lastEscapeDirection);
                this.obstacleCheckCooldown = 10;
            }
        } else {
            --this.obstacleCheckCooldown;
        }
        if (!this.lastEscapeDirection.equals((Object)Vec3.ZERO)) {
            this.smoothMovementTransition();
        }
        super.followThePath();
    }

    private void replanPathAwayFromObstacle(Vec3 currentPos, Vec3 escapeDirection) {
        Vec3 escapeTarget = currentPos.add(escapeDirection.scale(4.0));
        BlockPos targetPos = BlockPos.containing((Position)escapeTarget);
        Path path = this.createPath(targetPos, 1);
        if (path != null) {
            this.path = path;
        }
    }

    private void smoothMovementTransition() {
        Vec3 desiredMotion = this.lastEscapeDirection.scale(this.mob.getAttributeValue(Attributes.FLYING_SPEED) * 0.7);
        Vec3 currentMotion = this.mob.getDeltaMovement();
        Vec3 newMotion = currentMotion.lerp(desiredMotion, 0.3);
        this.mob.setDeltaMovement(newMotion);
        this.lastEscapeDirection = this.lastEscapeDirection.scale(0.8);
        if (this.lastEscapeDirection.lengthSqr() < 0.01) {
            this.lastEscapeDirection = Vec3.ZERO;
        }
    }

    public boolean moveTo(double x, double y, double z, double speed) {
        this.lastEscapeDirection = Vec3.ZERO;
        return super.moveTo(x, y, z, speed);
    }

    private BlockPos findObstacle(Vec3 position, int range) {
        BlockPos center = BlockPos.containing((Position)position);
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int y = -1; y <= 1; ++y) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    mutablePos.set(center.getX() + x, center.getY() + y, center.getZ() + z);
                    if (!this.mob.level().getBlockState((BlockPos)mutablePos).isSolid() || !this.mob.getBoundingBox().intersects(new AABB((BlockPos)mutablePos))) continue;
                    return mutablePos.immutable();
                }
            }
        }
        Vec3 velocity = this.mob.getDeltaMovement();
        if (velocity.lengthSqr() > 0.001) {
            Vec3 futurePos = position.add(velocity.scale(1.5));
            BlockPos futureCenter = BlockPos.containing((Position)futurePos);
            for (int y = -range; y <= range; ++y) {
                for (int x = -range; x <= range; ++x) {
                    for (int z = -range; z <= range; ++z) {
                        mutablePos.set(futureCenter.getX() + x, futureCenter.getY() + y, futureCenter.getZ() + z);
                        BlockState state = this.mob.level().getBlockState((BlockPos)mutablePos);
                        if (!state.isSolid() || state.is(BlockTags.LEAVES) || state.is(BlockTags.FLOWERS)) continue;
                        AABB blockBB = new AABB((BlockPos)mutablePos);
                        AABB expandedBB = this.mob.getBoundingBox().inflate(0.3);
                        if (!expandedBB.intersects(blockBB)) continue;
                        return mutablePos.immutable();
                    }
                }
            }
        }
        return null;
    }

    private Vec3 calculateEscapeVector(Vec3 entityPos, BlockPos obstacle) {
        Vec3 obstacleCenter = Vec3.atCenterOf((Vec3i)obstacle);
        Vec3 toObstacle = obstacleCenter.subtract(entityPos).normalize();
        Random random = (Random)this.mob.getRandom();
        ArrayList<Vec3> escapeDirections = new ArrayList<Vec3>();
        escapeDirections.add(toObstacle.reverse());
        Vec3 horizontalPerp = new Vec3(-toObstacle.z, 0.0, toObstacle.x).normalize();
        escapeDirections.add(horizontalPerp);
        escapeDirections.add(horizontalPerp.reverse());
        escapeDirections.add(new Vec3(0.0, 1.0, 0.0));
        escapeDirections.add(new Vec3(0.0, -1.0, 0.0));
        escapeDirections.add(horizontalPerp.add(0.0, 0.5, 0.0).normalize());
        escapeDirections.add(horizontalPerp.reverse().add(0.0, 0.5, 0.0).normalize());
        Vec3 bestDirection = null;
        double bestScore = Double.NEGATIVE_INFINITY;
        for (Vec3 dir : escapeDirections) {
            double score = this.evaluateEscapeDirection(entityPos, dir, obstacle);
            if (!(score > bestScore)) continue;
            bestScore = score;
            bestDirection = dir;
        }
        if (bestDirection == null) {
            return new Vec3(random.nextDouble() - 0.5, random.nextDouble() - 0.5, random.nextDouble() - 0.5).normalize();
        }
        return bestDirection.add((random.nextDouble() - 0.5) * 0.2, (random.nextDouble() - 0.5) * 0.2, (random.nextDouble() - 0.5) * 0.2).normalize();
    }

    private double evaluateEscapeDirection(Vec3 entityPos, Vec3 direction, BlockPos obstacle) {
        double score = 0.0;
        Vec3 testPos = entityPos.add(direction.scale(3.0));
        if (!this.mob.level().getBlockState(BlockPos.containing((Position)testPos)).isSolid()) {
            score += 50.0;
        }
        Vec3 toObstacle = Vec3.atCenterOf((Vec3i)obstacle).subtract(testPos);
        score += toObstacle.length() * 5.0;
        score -= Math.abs(testPos.y - entityPos.y) * 2.0;
        Vec3 currentMotion = this.mob.getDeltaMovement().normalize();
        if (currentMotion.lengthSqr() > 0.01) {
            score += direction.dot(currentMotion) * 10.0;
        }
        for (int i = 1; i <= 2; ++i) {
            Vec3 checkPos = entityPos.add(direction.scale((double)i));
            if (!this.mob.level().getBlockState(BlockPos.containing((Position)checkPos)).isSolid()) continue;
            score -= 30.0 / (double)i;
        }
        return score;
    }
}

