/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.particle;

import com.ovinter.mythsandlegends.particle.LampadParticle;
import com.ovinter.mythsandlegends.registry.MLParticles;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;

public class MLParticleProvider
implements ParticleProvider<SimpleParticleType> {
    private final SpriteSet spriteSet;
    private final Map<SimpleParticleType, BiFunction<ClientLevel, ParticleParams, Particle>> particleFactories = new HashMap<SimpleParticleType, BiFunction<ClientLevel, ParticleParams, Particle>>();

    public MLParticleProvider(SpriteSet spriteSet) {
        this.spriteSet = spriteSet;
        this.particleFactories.put(MLParticles.LAMPAD_BOOST_PARTICLE.get(), (level, params) -> new LampadParticle((ClientLevel)level, params.x, params.y, params.z, spriteSet));
    }

    public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        ParticleParams params = new ParticleParams(x, y, z, xSpeed, ySpeed, zSpeed);
        if (this.particleFactories.containsKey(type)) {
            return this.particleFactories.get(type).apply(level, params);
        }
        return null;
    }

    private static class ParticleParams {
        double x;
        double y;
        double z;
        double xSpeed;
        double ySpeed;
        double zSpeed;

        public ParticleParams(double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.xSpeed = xSpeed;
            this.ySpeed = ySpeed;
            this.zSpeed = zSpeed;
        }
    }
}

