/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.client.render.layer.player;

import com.ovinter.mythsandlegends.registry.MLEffects;
import com.ovinter.mythsandlegends.registry.MLItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderArmEvent;

@EventBusSubscriber(value={Dist.CLIENT})
public class ArmorFirstPersonRenderer {
    private static boolean rendererActive = false;
    private static ResourceLocation activeHand;
    private static final ResourceLocation ironshadeArmorArm;
    private static final ResourceLocation infernumWarplateArmorArm;
    private static final ResourceLocation petrifiedArm;

    public static void clientTick(LocalPlayer player) {
        boolean isDead = !player.isAlive();
        Item chestplateItem = player.getInventory().getArmor(2).getItem();
        boolean bl = rendererActive = chestplateItem == MLItems.IRONSHADE_CHESTPLATE.get() || chestplateItem == MLItems.INFERNUM_WARPLATE_CHESTPLATE.get() || chestplateItem == MLItems.SOULPIERCER_CHESTPLATE.get();
        if (isDead) {
            rendererActive = false;
            activeHand = null;
            return;
        }
        if (player.hasEffect(MLEffects.PETRIFIED)) {
            activeHand = petrifiedArm;
            return;
        }
        activeHand = chestplateItem == MLItems.IRONSHADE_CHESTPLATE.get() || chestplateItem == MLItems.SOULPIERCER_CHESTPLATE.get() ? ironshadeArmorArm : (chestplateItem == MLItems.INFERNUM_WARPLATE_CHESTPLATE.get() ? infernumWarplateArmorArm : null);
    }

    @SubscribeEvent
    public static void onRenderPlayerHand(RenderArmEvent event) {
        boolean shouldRender;
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null || !player.isAlive() || activeHand == null) {
            return;
        }
        boolean isLeftArm = event.getArm() == HumanoidArm.LEFT;
        boolean isHandEmpty = isLeftArm && player.getOffhandItem().isEmpty() || !isLeftArm && player.getMainHandItem().isEmpty();
        boolean bl = shouldRender = rendererActive || activeHand.equals((Object)petrifiedArm) || isHandEmpty;
        if (!shouldRender) {
            return;
        }
        MultiBufferSource buffer = event.getMultiBufferSource();
        EntityRenderer entityRenderer = mc.getEntityRenderDispatcher().getRenderer((Entity)player);
        if (!(entityRenderer instanceof PlayerRenderer)) {
            return;
        }
        PlayerRenderer pr = (PlayerRenderer)entityRenderer;
        PlayerModel model = (PlayerModel)pr.getModel();
        model.swimAmount = 0.0f;
        model.attackTime = 0.0f;
        model.crouching = false;
        model.rightArmPose = HumanoidModel.ArmPose.EMPTY;
        model.leftArmPose = HumanoidModel.ArmPose.EMPTY;
        model.setupAnim((LivingEntity)player, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        ModelPart baseArm = isLeftArm ? model.leftArm : model.rightArm;
        ModelPart sleeveArm = isLeftArm ? model.leftSleeve : model.rightSleeve;
        PlayerSkin skinTexture = player.getSkin();
        baseArm.render(event.getPoseStack(), buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)skinTexture.texture())), 0xF000F0, OverlayTexture.NO_OVERLAY);
        sleeveArm.xRot = 0.0f;
        sleeveArm.render(event.getPoseStack(), buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)activeHand)), 0xF000F0, OverlayTexture.NO_OVERLAY);
        event.setCanceled(true);
    }

    static {
        ironshadeArmorArm = ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)"textures/models/ironshade_armor_arm.png");
        infernumWarplateArmorArm = ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)"textures/models/infernum_warplate_armor_arm.png");
        petrifiedArm = ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)"textures/models/petrified_body.png");
    }
}

