/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.datagen;

import com.ovinter.mythsandlegends.registry.MLSounds;
import java.util.List;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.common.data.SoundDefinition;
import net.neoforged.neoforge.common.data.SoundDefinitionsProvider;

public class MLSoundDefinitionProvider
extends SoundDefinitionsProvider {
    protected MLSoundDefinitionProvider(PackOutput output, ExistingFileHelper helper) {
        super(output, "mythsandlegends", helper);
    }

    public void registerSounds() {
        this.addSingleSound((SoundEvent)MLSounds.PETRIFIED.value(), "petrified_effect");
        this.addSingleSound((SoundEvent)MLSounds.IMP_SHOOT.value(), "imp_shoot");
        this.addMultipleSounds((SoundEvent)MLSounds.POSSESSED_ARMOR_AMBIENT.value(), List.of("possessed_armor_ambient", "possessed_armor_ambient1"));
        this.addMultipleSounds((SoundEvent)MLSounds.POSSESSED_ARMOR_HURT.value(), List.of("possessed_armor_hurt", "possessed_armor_hurt1", "possessed_armor_hurt2", "possessed_armor_hurt3"));
        this.addMultipleSounds((SoundEvent)MLSounds.POSSESSED_ARMOR_DEATH.value(), List.of("possessed_armor_death", "possessed_armor_death1"));
        this.addSingleSound((SoundEvent)MLSounds.POSSESSED_ARMOR_STEP.value(), "possessed_armor_step");
        this.addSingleSound((SoundEvent)MLSounds.INQUISITOR_SUMMONING.value(), "inquisitor_summoning");
        this.addSingleSound((SoundEvent)MLSounds.SHOCKWAVE.value(), "shockwave");
        this.addMultipleSounds((SoundEvent)MLSounds.GARGOYLE_ATTACK.value(), List.of("gargoyle_attack", "gargoyle_attack1"));
        this.addMultipleSounds((SoundEvent)MLSounds.GARGOYLE_AMBIENT.value(), List.of("gargoyle_ambient", "gargoyle_ambient1", "gargoyle_ambient2"));
        this.addSingleSound((SoundEvent)MLSounds.GARGOYLE_STEP.value(), "gargoyle_step");
        this.addMultipleSounds((SoundEvent)MLSounds.GARGOYLE_HURT.value(), List.of("gargoyle_hurt", "gargoyle_hurt1"));
        this.addSingleSound((SoundEvent)MLSounds.GARGOYLE_DEATH.value(), "gargoyle_death");
        this.addSingleSound((SoundEvent)MLSounds.BLACK_CHARRO_RITUAL.value(), "black_charro_ritual");
        this.addSingleSound((SoundEvent)MLSounds.BLACK_CHARRO_DEATH.value(), "black_charro_death");
        this.addSingleSound((SoundEvent)MLSounds.BLACK_CHARRO_TELEPORT.value(), "black_charro_teleport");
        this.addSingleSound((SoundEvent)MLSounds.BLACK_CHARRO_SUMMON.value(), "black_charro_summon");
        this.addSingleSound((SoundEvent)MLSounds.BLACK_CHARRO_RAGE.value(), "black_charro_rage");
        this.addMultipleSounds((SoundEvent)MLSounds.BLACK_CHARRO_HURT.value(), List.of("black_charro_hurt", "black_charro_hurt1"));
        this.addMultipleSounds((SoundEvent)MLSounds.BLACK_CHARRO_AMBIENT.value(), List.of("black_charro_ambient", "black_charro_ambient1", "black_charro_ambient2", "black_charro_ambient3"));
        this.addSingleSound((SoundEvent)MLSounds.UMBRAL_DOOM_ORB_SHOOT.value(), "umbral_doom_orb_shoot");
        this.addSingleSound((SoundEvent)MLSounds.UMBRAL_DOOM_ORB_EXPLOSION.value(), "umbral_doom_orb_explosion");
        this.addMultipleSounds((SoundEvent)MLSounds.CONDEMNED_AMBIENT.value(), List.of("condemned_ambient", "condemned_ambient1"));
        this.addMultipleSounds((SoundEvent)MLSounds.CONDEMNED_HURT.value(), List.of("condemned_hurt", "condemned_hurt1"));
        this.addSingleSound((SoundEvent)MLSounds.CONDEMNED_DEATH.value(), "condemned_death");
        this.addSingleSound((SoundEvent)MLSounds.LAMPAD_AMBIENT.value(), "condemned_death");
        this.addMultipleSounds((SoundEvent)MLSounds.LAMPAD_HURT.value(), List.of("lampad_hurt", "lampad_hurt1"));
        this.addSingleSound((SoundEvent)MLSounds.LAMPAD_DEATH.value(), "condemned_death");
        this.addMultipleSounds((SoundEvent)MLSounds.WARBORN_AEGIS_AMBIENT.value(), List.of("warborn_aegis_ambient", "warborn_aegis_ambient1"));
        this.addMultipleSounds((SoundEvent)MLSounds.WARBORN_AEGIS_ATTACK.value(), List.of("warborn_aegis_attack", "warborn_aegis_attack1"));
        this.addSingleSound((SoundEvent)MLSounds.WARBORN_AEGIS_DEATH.value(), "warborn_aegis_death");
        this.addMultipleSounds((SoundEvent)MLSounds.WARBORN_AEGIS_HURT.value(), List.of("warborn_aegis_hurt", "warborn_aegis_hurt1"));
        this.addSingleSound((SoundEvent)MLSounds.WARBORN_AEGIS_JUMP.value(), "warborn_aegis_jump");
        this.addSingleSound((SoundEvent)MLSounds.WARBORN_AEGIS_STAMPEDE_HIT.value(), "warborn_aegis_stampede_hit");
        this.addSingleSound((SoundEvent)MLSounds.WARBORN_AEGIS_STEP.value(), "warborn_aegis_step");
        this.addSingleSound((SoundEvent)MLSounds.WARBORN_AEGIS_RAGE.value(), "warborn_aegis_rage");
        this.addSingleSound((SoundEvent)MLSounds.IGNIS_NEXUS_DESTROYED.value(), "ignis_nexus_destroyed");
        this.addMultipleSounds((SoundEvent)MLSounds.ABADDON_AMBIENT.value(), List.of("abaddon_ambient", "abaddon_ambient1", "abaddon_ambient2", "abaddon_ambient3"));
        this.addMultipleSounds((SoundEvent)MLSounds.ABADDON_ATTACK.value(), List.of("abaddon_attack", "abaddon_attack1", "abaddon_attack2"));
        this.addMultipleSounds((SoundEvent)MLSounds.ABADDON_HURT.value(), List.of("abaddon_hurt", "abaddon_hurt1", "abaddon_hurt2", "abaddon_hurt3"));
        this.addMultipleSounds((SoundEvent)MLSounds.ABADDON_DEATH.value(), List.of("abaddon_death", "abaddon_death1", "abaddon_death2"));
        this.addMultipleSounds((SoundEvent)MLSounds.SCORCHED_SENTINEL_AMBIENT.value(), List.of("scorched_sentinel_ambient", "scorched_sentinel_ambient1", "scorched_sentinel_ambient2", "scorched_sentinel_ambient3"));
        this.addMultipleSounds((SoundEvent)MLSounds.SCORCHED_SENTINEL_ATTACK.value(), List.of("scorched_sentinel_attack", "scorched_sentinel_attack1"));
        this.addMultipleSounds((SoundEvent)MLSounds.SCORCHED_SENTINEL_HURT.value(), List.of("scorched_sentinel_hurt", "scorched_sentinel_hurt1", "scorched_sentinel_hurt2", "scorched_sentinel_hurt3", "scorched_sentinel_hurt4"));
        this.addMultipleSounds((SoundEvent)MLSounds.SCORCHED_SENTINEL_DEATH.value(), List.of("scorched_sentinel_death", "scorched_sentinel_death1", "scorched_sentinel_death2"));
        this.addMultipleSounds((SoundEvent)MLSounds.ALP_AMBIENT.value(), List.of("alp_ambient", "alp_ambient1", "alp_ambient2", "alp_ambient3"));
        this.addSingleSound((SoundEvent)MLSounds.ALP_DEATH.value(), "alp_death");
        this.addSingleSound((SoundEvent)MLSounds.ALP_STEP.value(), "alp_step");
        this.addMultipleSounds((SoundEvent)MLSounds.KARAKONDJUL_AMBIENT.value(), List.of("karakondjul_ambient", "karakondjul_ambient1", "karakondjul_ambient2", "karakondjul_ambient3"));
        this.addMultipleSounds((SoundEvent)MLSounds.KARAKONDJUL_HURT.value(), List.of("karakondjul_hurt", "karakondjul_hurt1", "karakondjul_hurt2", "karakondjul_hurt3"));
        this.addSingleSound((SoundEvent)MLSounds.KARAKONDJUL_DEATH.value(), "karakondjul_death");
        this.addSingleSound((SoundEvent)MLSounds.CANDLE_KEEPER_EXPLOSION.value(), "candle_keeper_explosion");
        this.addMultipleSounds((SoundEvent)MLSounds.AMAROK_ATTACK.value(), List.of("amarok_attack", "amarok_attack1", "amarok_attack2"));
        this.addMultipleSounds((SoundEvent)MLSounds.AMAROK_GROWL.value(), List.of("amarok_growl", "amarok_growl1", "amarok_growl2"));
        this.addMultipleSounds((SoundEvent)MLSounds.AMAROK_HOWL.value(), List.of("amarok_howl", "amarok_howl1"));
        this.addMultipleSounds((SoundEvent)MLSounds.AMAROK_HURT.value(), List.of("amarok_hurt", "amarok_hurt1", "amarok_hurt2"));
        this.addMultipleSounds((SoundEvent)MLSounds.AMAROK_DEATH.value(), List.of("amarok_death", "amarok_death1", "amarok_death2"));
        this.addSingleSound((SoundEvent)MLSounds.RUPTURE_BURST.value(), "rupture_burst");
        this.addSingleSound((SoundEvent)MLSounds.GENERIC_ARMOR_EQUIPMENT.value(), "generic_armor_equipment");
        this.addSingleSound((SoundEvent)MLSounds.SVAROGS_RING.value(), "svarogs_ring");
        this.addSingleSound((SoundEvent)MLSounds.JUMP_SCARE.value(), "jump_scare");
        this.addSingleSound((SoundEvent)MLSounds.STONE_SANCTUM.value(), "stone_sanctum");
    }

    protected void addSingleSound(SoundEvent pName, String pPath) {
        this.add(pName, MLSoundDefinitionProvider.definition().with(MLSoundDefinitionProvider.sound((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)pPath))).subtitle(this.defaultSubtitleKey(pPath)));
    }

    protected void addMultipleSounds(SoundEvent pName, List<String> pPaths) {
        SoundDefinition definition = MLSoundDefinitionProvider.definition();
        for (String soundPath : pPaths) {
            definition.with(MLSoundDefinitionProvider.sound((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)soundPath))).subtitle(this.defaultSubtitleKey(pPaths.getFirst()));
        }
        this.add(pName, definition);
    }

    private String defaultSubtitleKey(String pSoundPath) {
        return "subtitles.mythsandlegends." + pSoundPath;
    }
}

