/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.effect.armor;

import com.ovinter.mythsandlegends.effect.armor.ArmorSetEffect;
import com.ovinter.mythsandlegends.registry.MLItems;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.registries.DeferredItem;

public class FrosthowlEffect
implements ArmorSetEffect {
    private static final DeferredItem<ArmorItem> HELMET = MLItems.FROSTHOWL_HELMET;
    private static final DeferredItem<ArmorItem> CHESTPLATE = MLItems.FROSTHOWL_CHESTPLATE;
    private static final DeferredItem<ArmorItem> LEGGINGS = MLItems.FROSTHOWL_LEGGINGS;
    private static final DeferredItem<ArmorItem> BOOTS = MLItems.FROSTHOWL_BOOTS;

    @Override
    public void applyEffects(ServerPlayer pPlayer, boolean pIsNight) {
        if (!this.isInColdBiome(pPlayer)) {
            this.removeEffects(pPlayer);
            return;
        }
        pPlayer.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, -1, 0, false, false));
        if (pPlayer.isInPowderSnow) {
            pPlayer.setTicksFrozen(0);
        }
    }

    @Override
    public void removeEffects(ServerPlayer pPlayer) {
        pPlayer.removeEffect(MobEffects.MOVEMENT_SPEED);
    }

    @Override
    public boolean matchesFullSet(LivingEntity pPlayer) {
        return pPlayer.getItemBySlot(EquipmentSlot.HEAD).getItem() == HELMET.get() && pPlayer.getItemBySlot(EquipmentSlot.CHEST).getItem() == CHESTPLATE.get() && pPlayer.getItemBySlot(EquipmentSlot.LEGS).getItem() == LEGGINGS.get() && pPlayer.getItemBySlot(EquipmentSlot.FEET).getItem() == BOOTS.get();
    }

    private boolean isInColdBiome(ServerPlayer pPlayer) {
        Holder biome = pPlayer.level().getBiome(pPlayer.getOnPos());
        return biome.is(Tags.Biomes.IS_SNOWY) || biome.is(Tags.Biomes.IS_ICY);
    }
}

